/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker;

import bt.net.Peer;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public class TrackerResponse {
    private final boolean success;
    private final Optional<Throwable> error;
    private String errorMessage;
    private String warningMessage;
    private int interval;
    private int minInterval;
    private Optional<byte[]> trackerId;
    private int seederCount;
    private int leecherCount;
    private Iterable<Peer> peers;

    public static TrackerResponse ok() {
        return new TrackerResponse();
    }

    public static TrackerResponse failure(String errorMessage) {
        return new TrackerResponse(errorMessage);
    }

    public static TrackerResponse exceptional(Throwable error) {
        return new TrackerResponse(error);
    }

    protected TrackerResponse() {
        this(true, null);
    }

    protected TrackerResponse(String errorMessage) {
        this(false, null);
        this.errorMessage = errorMessage;
    }

    protected TrackerResponse(Throwable error) {
        this(false, Objects.requireNonNull(error));
    }

    private TrackerResponse(boolean success, Throwable error) {
        this.success = success;
        this.error = Optional.ofNullable(error);
        this.trackerId = Optional.empty();
        this.peers = Collections.emptyList();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    public Optional<Throwable> getError() {
        return this.error;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public int getMinInterval() {
        return this.minInterval;
    }

    public void setMinInterval(int minInterval) {
        this.minInterval = minInterval;
    }

    public Optional<byte[]> getTrackerId() {
        return this.trackerId;
    }

    public void setTrackerId(byte[] trackerId) {
        this.trackerId = Optional.of(trackerId);
    }

    public int getSeederCount() {
        return this.seederCount;
    }

    public void setSeederCount(int seederCount) {
        this.seederCount = seederCount;
    }

    public int getLeecherCount() {
        return this.leecherCount;
    }

    public void setLeecherCount(int leecherCount) {
        this.leecherCount = leecherCount;
    }

    public Iterable<Peer> getPeers() {
        return this.peers;
    }

    public void setPeers(Iterable<Peer> peers) {
        this.peers = peers;
    }
}

