/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker;

import bt.BtException;
import bt.module.TrackerFactories;
import bt.tracker.AnnounceKey;
import bt.tracker.ITrackerService;
import bt.tracker.MultiTracker;
import bt.tracker.Tracker;
import bt.tracker.TrackerFactory;
import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TrackerService
implements ITrackerService {
    private Map<String, TrackerFactory> trackerFactories;
    private ConcurrentMap<String, Tracker> knownTrackers;

    @Inject
    public TrackerService(@TrackerFactories Map<String, TrackerFactory> trackerFactories) {
        this.trackerFactories = trackerFactories;
        this.knownTrackers = new ConcurrentHashMap<String, Tracker>();
    }

    @Override
    public boolean isSupportedProtocol(String trackerUrl) {
        return this.trackerFactories.containsKey(TrackerService.getProtocol(trackerUrl));
    }

    @Override
    public Tracker getTracker(String trackerUrl) {
        return this.getOrCreateTracker(trackerUrl);
    }

    @Override
    public Tracker getTracker(AnnounceKey announceKey) {
        if (announceKey.isMultiKey()) {
            return new MultiTracker(this, announceKey);
        }
        return this.getOrCreateTracker(announceKey.getTrackerUrl());
    }

    private Tracker getOrCreateTracker(String trackerUrl) {
        Tracker existing;
        Tracker tracker = (Tracker)this.knownTrackers.get(trackerUrl);
        if (tracker == null && (existing = this.knownTrackers.putIfAbsent(trackerUrl, tracker = this.createTracker(trackerUrl))) != null) {
            tracker = existing;
        }
        return tracker;
    }

    private Tracker createTracker(String trackerUrl) {
        String protocol = TrackerService.getProtocol(trackerUrl);
        TrackerFactory factory = this.trackerFactories.get(protocol);
        if (factory == null) {
            throw new BtException("Unsupported tracker protocol: " + protocol);
        }
        return factory.getTracker(trackerUrl);
    }

    private static String getProtocol(String url) {
        int schemaDelimiterIndex = url.indexOf("://");
        if (schemaDelimiterIndex < 1) {
            throw new IllegalArgumentException("Invalid URL: " + url);
        }
        return url.substring(0, schemaDelimiterIndex);
    }
}

