/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker.udp;

import bt.metainfo.TorrentId;
import bt.net.PeerId;
import bt.protocol.Protocols;
import bt.tracker.udp.UdpTrackerMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;

class AnnounceRequest
extends UdpTrackerMessage {
    private static final int ANNOUNCE_TYPE_ID = 1;
    private TorrentId torrentId;
    private PeerId peerId;
    private long downloaded;
    private long left;
    private long uploaded;
    private int numwant;
    private EventType eventType;
    private short listeningPort;
    private String requestString;

    public AnnounceRequest() {
        super(1);
    }

    public void setTorrentId(TorrentId torrentId) {
        this.torrentId = torrentId;
    }

    public void setPeerId(PeerId peerId) {
        this.peerId = peerId;
    }

    public void setDownloaded(long downloaded) {
        this.downloaded = downloaded;
    }

    public void setLeft(long left) {
        this.left = left;
    }

    public void setUploaded(long uploaded) {
        this.uploaded = uploaded;
    }

    public void setNumwant(int numwant) {
        this.numwant = numwant;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public void setListeningPort(short listeningPort) {
        this.listeningPort = listeningPort;
    }

    public void setRequestString(String requestString) {
        this.requestString = requestString;
    }

    @Override
    protected void writeBodyTo(OutputStream out) throws IOException {
        out.write(Objects.requireNonNull(this.torrentId).getBytes());
        out.write(Objects.requireNonNull(this.peerId).getBytes());
        out.write(Protocols.getLongBytes(this.downloaded));
        out.write(Protocols.getLongBytes(this.left));
        out.write(Protocols.getLongBytes(this.uploaded));
        out.write(Protocols.getIntBytes(Objects.requireNonNull(this.eventType).code()));
        out.write(Protocols.getIntBytes(0));
        out.write(Protocols.getIntBytes(0));
        out.write(Protocols.getIntBytes(this.numwant));
        out.write(Protocols.getShortBytes(this.listeningPort));
        if (this.requestString != null) {
            out.write(2);
            byte[] bytes = this.requestString.getBytes("ISO-8859-1");
            if (bytes.length > 255) {
                bytes = Arrays.copyOfRange(bytes, 0, 255);
            }
            out.write(bytes.length);
            out.write(bytes);
        } else {
            out.write(Protocols.getShortBytes(0));
        }
    }

    @Override
    public String toString() {
        return "AnnounceRequest{id=" + this.getId() + ", torrentId=" + this.torrentId + ", peerId=" + this.peerId + ", downloaded=" + this.downloaded + ", left=" + this.left + ", uploaded=" + this.uploaded + ", eventType=" + (Object)((Object)this.eventType) + (this.eventType == null ? "" : "(" + this.eventType.code + ")") + ", listeningPort=" + this.listeningPort + (this.requestString == null ? "" : ", requestString=" + this.requestString) + '}';
    }

    public static enum EventType {
        QUERY(0),
        COMPLETE(1),
        START(2),
        STOP(3);

        private int code;

        private EventType(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }
    }
}

