/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker.udp;

import bt.protocol.Protocols;
import bt.tracker.CompactPeerInfo;
import bt.tracker.TrackerResponse;
import bt.tracker.udp.UdpTrackerResponseHandler;
import java.util.Arrays;

class AnnounceResponseHandler
implements UdpTrackerResponseHandler<TrackerResponse> {
    private static final int INTERVAL_OFFSET = 0;
    private static final int LEECHERS_OFFSET = 4;
    private static final int SEEDERS_OFFSET = 8;
    private static final int PEERS_OFFSET = 12;
    private static AnnounceResponseHandler instance = new AnnounceResponseHandler();

    AnnounceResponseHandler() {
    }

    public static AnnounceResponseHandler handler() {
        return instance;
    }

    @Override
    public TrackerResponse onSuccess(byte[] data) {
        TrackerResponse response = TrackerResponse.ok();
        response.setInterval(Protocols.readInt(data, 0));
        response.setLeecherCount(Protocols.readInt(data, 4));
        response.setSeederCount(Protocols.readInt(data, 8));
        if (data.length > 12) {
            byte[] peers = Arrays.copyOfRange(data, 12, data.length);
            response.setPeers(new CompactPeerInfo(peers, CompactPeerInfo.AddressType.IPV4));
        }
        return response;
    }

    @Override
    public TrackerResponse onError(String message) {
        return TrackerResponse.failure(message);
    }
}

