/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker.udp;

import bt.metainfo.TorrentId;
import bt.service.IRuntimeLifecycleBinder;
import bt.service.IdentityService;
import bt.tracker.Tracker;
import bt.tracker.TrackerRequestBuilder;
import bt.tracker.TrackerResponse;
import bt.tracker.udp.AnnounceRequest;
import bt.tracker.udp.AnnounceResponseHandler;
import bt.tracker.udp.UdpMessageWorker;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UdpTracker
implements Tracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(UdpTracker.class);
    private IdentityService idService;
    private int listeningPort;
    private int numberOfPeersToRequestFromTracker;
    private URL trackerUrl;
    private UdpMessageWorker worker;

    public UdpTracker(IdentityService idService, IRuntimeLifecycleBinder lifecycleBinder, InetAddress localAddress, int listeningPort, int numberOfPeersToRequestFromTracker, String trackerUrl) {
        this.idService = idService;
        this.listeningPort = listeningPort;
        this.numberOfPeersToRequestFromTracker = numberOfPeersToRequestFromTracker;
        this.trackerUrl = this.toUrl(trackerUrl);
        this.worker = new UdpMessageWorker(new InetSocketAddress(localAddress, 0), this.getSocketAddress(this.trackerUrl), lifecycleBinder);
    }

    private URL toUrl(String s) {
        if (!s.startsWith("udp://")) {
            throw new IllegalArgumentException("Unexpected URL format: " + s);
        }
        s = s.replace("udp://", "http://");
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL: " + s);
        }
    }

    private SocketAddress getSocketAddress(URL url) {
        String host = Objects.requireNonNull(url.getHost(), "Host name is required");
        int port = this.getPort(url);
        return new InetSocketAddress(host, port);
    }

    private int getPort(URL url) {
        int port = url.getPort();
        if (port < 0 && (port = url.getDefaultPort()) < 0) {
            throw new IllegalArgumentException("Can't determine port from URL: " + url.toExternalForm());
        }
        return port;
    }

    @Override
    public TrackerRequestBuilder request(TorrentId torrentId) {
        return new TrackerRequestBuilder(torrentId){

            @Override
            public TrackerResponse start() {
                return this.announceEvent(AnnounceRequest.EventType.START);
            }

            @Override
            public TrackerResponse stop() {
                return this.announceEvent(AnnounceRequest.EventType.STOP);
            }

            @Override
            public TrackerResponse complete() {
                return this.announceEvent(AnnounceRequest.EventType.COMPLETE);
            }

            @Override
            public TrackerResponse query() {
                return this.announceEvent(AnnounceRequest.EventType.QUERY);
            }

            private TrackerResponse announceEvent(AnnounceRequest.EventType eventType) {
                AnnounceRequest request = new AnnounceRequest();
                request.setTorrentId(this.getTorrentId());
                request.setPeerId(UdpTracker.this.idService.getLocalPeerId());
                request.setEventType(eventType);
                request.setListeningPort((short)UdpTracker.this.listeningPort);
                request.setDownloaded(this.getDownloaded());
                request.setUploaded(this.getUploaded());
                request.setLeft(this.getLeft());
                request.setNumwant(UdpTracker.this.numberOfPeersToRequestFromTracker);
                UdpTracker.this.getRequestString(UdpTracker.this.trackerUrl).ifPresent(request::setRequestString);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Executing tracker UDP request of type {}: {}", (Object)eventType.name(), (Object)request);
                }
                try {
                    return UdpTracker.this.worker.sendMessage(request, AnnounceResponseHandler.handler());
                }
                catch (Exception e) {
                    return TrackerResponse.exceptional(e);
                }
            }
        };
    }

    private Optional<String> getRequestString(URL url) {
        String result = url.getPath();
        if (url.getQuery() != null) {
            result = result + "?" + url.getQuery();
        }
        return result.isEmpty() ? Optional.empty() : Optional.of(result);
    }

    public String toString() {
        return "UdpTracker{trackerUrl=" + this.trackerUrl + '}';
    }
}

