/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker.udp;

import bt.runtime.Config;
import bt.service.IRuntimeLifecycleBinder;
import bt.service.IdentityService;
import bt.tracker.Tracker;
import bt.tracker.TrackerFactory;
import bt.tracker.udp.UdpTracker;
import com.google.inject.Inject;

public class UdpTrackerFactory
implements TrackerFactory {
    private IdentityService idService;
    private IRuntimeLifecycleBinder lifecycleBinder;
    private Config config;

    @Inject
    public UdpTrackerFactory(IdentityService idService, IRuntimeLifecycleBinder lifecycleBinder, Config config) {
        this.idService = idService;
        this.lifecycleBinder = lifecycleBinder;
        this.config = config;
    }

    @Override
    public Tracker getTracker(String trackerUrl) {
        return new UdpTracker(this.idService, this.lifecycleBinder, this.config.getAcceptorAddress(), this.config.getAcceptorPort(), this.config.getNumberOfPeersToRequestFromTracker(), trackerUrl);
    }
}

