/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker.udp;

import bt.protocol.Protocols;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;

abstract class UdpTrackerMessage {
    private int messageType;
    private int id;

    public UdpTrackerMessage(int messageType) {
        this.messageType = messageType;
        this.id = new Random(System.currentTimeMillis()).nextInt();
    }

    public int getId() {
        return this.id;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(Protocols.getIntBytes(this.messageType));
        out.write(Protocols.getIntBytes(this.id));
        this.writeBodyTo(out);
    }

    protected abstract void writeBodyTo(OutputStream var1) throws IOException;

    public String toString() {
        return this.getClass().getName() + "{messageType=" + this.messageType + ", id=" + this.id + '}';
    }
}

