/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker.http;

import bt.BtException;
import bt.metainfo.TorrentId;
import bt.net.Peer;
import bt.peer.IPeerRegistry;
import bt.protocol.crypto.EncryptionPolicy;
import bt.service.IdentityService;
import bt.tracker.SecretKey;
import bt.tracker.Tracker;
import bt.tracker.TrackerRequestBuilder;
import bt.tracker.TrackerResponse;
import bt.tracker.http.CommonsHttpResponseHandler;
import bt.tracker.http.HttpResponseHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTracker
implements Tracker {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTracker.class);
    private URI baseUri;
    private IdentityService idService;
    private IPeerRegistry peerRegistry;
    private EncryptionPolicy encryptionPolicy;
    private int numberOfPeersToRequestFromTracker;
    private HttpClient httpClient;
    private CommonsHttpResponseHandler httpResponseHandler;
    private ConcurrentMap<URI, byte[]> trackerIds;

    public HttpTracker(String trackerUrl, IdentityService idService, IPeerRegistry peerRegistry, EncryptionPolicy encryptionPolicy, InetAddress localAddress, int numberOfPeersToRequestFromTracker) {
        try {
            this.baseUri = new URI(trackerUrl);
        }
        catch (URISyntaxException e) {
            throw new BtException("Invalid URL: " + trackerUrl, (Throwable)e);
        }
        this.idService = idService;
        this.peerRegistry = peerRegistry;
        this.encryptionPolicy = encryptionPolicy;
        this.numberOfPeersToRequestFromTracker = numberOfPeersToRequestFromTracker;
        this.httpClient = HttpTracker.buildClient(localAddress);
        this.httpResponseHandler = new CommonsHttpResponseHandler(new HttpResponseHandler());
        this.trackerIds = new ConcurrentHashMap<URI, byte[]>();
    }

    private static HttpClient buildClient(InetAddress localAddress) {
        CloseableHttpClient client = HttpClients.createMinimal();
        client.getParams().setParameter("http.route.local-address", (Object)localAddress);
        return client;
    }

    public TrackerRequestBuilder request(TorrentId torrentId) {
        return new TrackerRequestBuilder(torrentId){

            public TrackerResponse start() {
                return HttpTracker.this.sendEvent(TrackerRequestType.START, this);
            }

            public TrackerResponse stop() {
                return HttpTracker.this.sendEvent(TrackerRequestType.STOP, this);
            }

            public TrackerResponse complete() {
                return HttpTracker.this.sendEvent(TrackerRequestType.COMPLETE, this);
            }

            public TrackerResponse query() {
                return HttpTracker.this.sendEvent(TrackerRequestType.QUERY, this);
            }
        };
    }

    private TrackerResponse sendEvent(TrackerRequestType eventType, TrackerRequestBuilder requestBuilder) {
        String requestUri;
        try {
            String query = this.buildQuery(eventType, requestBuilder);
            String baseUrl = this.baseUri.toASCIIString();
            if (baseUrl.endsWith("/")) {
                baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
            }
            URL requestUrl = new URL(baseUrl + (this.baseUri.getRawQuery() == null ? "?" : "&") + query);
            requestUri = requestUrl.toURI().toString();
        }
        catch (Exception e) {
            throw new BtException("Failed to build tracker request", (Throwable)e);
        }
        HttpGet request = new HttpGet(requestUri);
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing tracker HTTP request of type " + eventType.name() + "; request URL: " + requestUri);
            }
            return (TrackerResponse)this.httpClient.execute((HttpUriRequest)request, (ResponseHandler)this.httpResponseHandler);
        }
        catch (IOException e) {
            return TrackerResponse.exceptional((Throwable)e);
        }
    }

    private String buildQuery(TrackerRequestType eventType, TrackerRequestBuilder requestBuilder) throws Exception {
        byte[] trackerId;
        StringBuilder buf = new StringBuilder();
        buf.append("info_hash=");
        buf.append(this.urlEncode(requestBuilder.getTorrentId().getBytes()));
        buf.append("&peer_id=");
        buf.append(this.urlEncode(this.idService.getLocalPeerId().getBytes()));
        Peer peer = this.peerRegistry.getLocalPeer();
        InetAddress inetAddress = peer.getInetAddress();
        if (inetAddress != null) {
            buf.append("&ip=");
            buf.append(this.urlEncode(inetAddress.getHostAddress().getBytes()));
        }
        buf.append("&port=");
        buf.append(peer.getPort());
        buf.append("&uploaded=");
        buf.append(requestBuilder.getUploaded());
        buf.append("&downloaded=");
        buf.append(requestBuilder.getDownloaded());
        buf.append("&left=");
        buf.append(requestBuilder.getLeft());
        buf.append("&compact=1");
        buf.append("&numwant=");
        buf.append(this.numberOfPeersToRequestFromTracker);
        Optional secretKey = this.idService.getSecretKey();
        if (secretKey.isPresent()) {
            buf.append("&key=");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ((SecretKey)secretKey.get()).writeTo((OutputStream)bos);
            buf.append(this.urlEncode(bos.toByteArray()));
        }
        if ((trackerId = (byte[])this.trackerIds.get(this.baseUri)) != null) {
            buf.append("&trackerid=");
            buf.append(this.urlEncode(trackerId));
        }
        switch (eventType) {
            case START: {
                buf.append("&event=started");
                break;
            }
            case STOP: {
                buf.append("&event=stopped");
                break;
            }
            case COMPLETE: {
                buf.append("&event=completed");
                break;
            }
            case QUERY: {
                break;
            }
            default: {
                throw new BtException("Unexpected event type: " + eventType.name().toLowerCase());
            }
        }
        switch (this.encryptionPolicy) {
            case PREFER_PLAINTEXT: {
                buf.append("&supportcrypto=1");
                break;
            }
            case PREFER_ENCRYPTED: 
            case REQUIRE_ENCRYPTED: {
                buf.append("&requirecrypto=1");
                break;
            }
        }
        return buf.toString();
    }

    private String urlEncode(byte[] bytes) {
        StringBuilder buf = new StringBuilder();
        for (byte b : bytes) {
            char c = (char)b;
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '-' || c == '.' || c == '_' || c == '~') {
                buf.append(c);
                continue;
            }
            buf.append("%");
            String hex = Integer.toHexString(b & 0xFF).toUpperCase();
            if (hex.length() == 1) {
                buf.append("0");
            }
            buf.append(hex);
        }
        return buf.toString();
    }

    public String toString() {
        return "HttpTracker{baseUri=" + this.baseUri + '}';
    }

    private static enum TrackerRequestType {
        START,
        STOP,
        COMPLETE,
        QUERY;

    }
}

