/*
 * Decompiled with CFR 0.152.
 */
package bt.tracker.http;

import bt.peer.IPeerRegistry;
import bt.protocol.crypto.EncryptionPolicy;
import bt.runtime.Config;
import bt.service.IdentityService;
import bt.tracker.Tracker;
import bt.tracker.TrackerFactory;
import bt.tracker.http.HttpTracker;
import com.google.inject.Inject;
import java.net.InetAddress;

public class HttpTrackerFactory
implements TrackerFactory {
    private IdentityService idService;
    private IPeerRegistry peerRegistry;
    private EncryptionPolicy encryptionPolicy;
    private InetAddress localAddress;
    private int numberOfPeersToRequestFromTracker;

    @Inject
    public HttpTrackerFactory(IdentityService idService, IPeerRegistry peerRegistry, Config config) {
        this.idService = idService;
        this.peerRegistry = peerRegistry;
        this.encryptionPolicy = config.getEncryptionPolicy();
        this.localAddress = config.getAcceptorAddress();
        this.numberOfPeersToRequestFromTracker = config.getNumberOfPeersToRequestFromTracker();
    }

    public Tracker getTracker(String trackerUrl) {
        return new HttpTracker(trackerUrl, this.idService, this.peerRegistry, this.encryptionPolicy, this.localAddress, this.numberOfPeersToRequestFromTracker);
    }
}

