/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpShakeService;
import me.chanjar.weixin.mp.bean.WxMpShakeInfoResult;
import me.chanjar.weixin.mp.bean.WxMpShakeQuery;
import me.chanjar.weixin.mp.bean.shake.WxMpShakeAroundDeviceBindPageQuery;
import me.chanjar.weixin.mp.bean.shake.WxMpShakeAroundPageAddQuery;
import me.chanjar.weixin.mp.bean.shake.WxMpShakeAroundPageAddResult;
import me.chanjar.weixin.mp.bean.shake.WxMpShakeAroundRelationSearchQuery;
import me.chanjar.weixin.mp.bean.shake.WxMpShakeAroundRelationSearchResult;

public class WxMpShakeServiceImpl
implements WxMpShakeService {
    private WxMpService wxMpService;

    public WxMpShakeServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public WxMpShakeInfoResult getShakeInfo(WxMpShakeQuery wxMpShakeQuery) throws WxErrorException {
        String url = "https://api.weixin.qq.com/shakearound/user/getshakeinfo";
        String postData = wxMpShakeQuery.toJsonString();
        String responseContent = this.wxMpService.post(url, postData);
        return WxMpShakeInfoResult.fromJson(responseContent);
    }

    @Override
    public WxMpShakeAroundPageAddResult pageAdd(WxMpShakeAroundPageAddQuery shakeAroundPageAddQuery) throws WxErrorException {
        String url = "https://api.weixin.qq.com/shakearound/page/add";
        String postData = shakeAroundPageAddQuery.toJsonString();
        String responseContent = this.wxMpService.post(url, postData);
        return WxMpShakeAroundPageAddResult.fromJson(responseContent);
    }

    @Override
    public WxError deviceBindPageQuery(WxMpShakeAroundDeviceBindPageQuery shakeAroundDeviceBindPageQuery) throws WxErrorException {
        String url = "https://api.weixin.qq.com/shakearound/device/bindpage";
        String postData = shakeAroundDeviceBindPageQuery.toJsonString();
        String responseContent = this.wxMpService.post(url, postData);
        return WxError.fromJson((String)responseContent);
    }

    @Override
    public WxMpShakeAroundRelationSearchResult relationSearch(WxMpShakeAroundRelationSearchQuery shakeAroundRelationSearchQuery) throws WxErrorException {
        String url = "https://api.weixin.qq.com/shakearound/relation/search";
        String postData = shakeAroundRelationSearchQuery.toJsonString();
        String responseContent = this.wxMpService.post(url, postData);
        return WxMpShakeAroundRelationSearchResult.fromJson(responseContent);
    }
}

