/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.v3;

import com.github.binarywang.wxpay.v3.Credentials;
import com.github.binarywang.wxpay.v3.SignatureExec;
import com.github.binarywang.wxpay.v3.Validator;
import com.github.binarywang.wxpay.v3.auth.CertificatesVerifier;
import com.github.binarywang.wxpay.v3.auth.PrivateKeySigner;
import com.github.binarywang.wxpay.v3.auth.WxPayCredentials;
import com.github.binarywang.wxpay.v3.auth.WxPayValidator;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.execchain.ClientExecChain;

public class WxPayV3HttpClientBuilder
extends HttpClientBuilder {
    private Credentials credentials;
    private Validator validator;
    static final String OS = System.getProperty("os.name") + "/" + System.getProperty("os.version");
    static final String VERSION = System.getProperty("java.version");

    private WxPayV3HttpClientBuilder() {
        String userAgent = String.format("WechatPay-Apache-HttpClient/%s (%s) Java/%s", ((Object)((Object)this)).getClass().getPackage().getImplementationVersion(), OS, VERSION == null ? "Unknown" : VERSION);
        this.setUserAgent(userAgent);
    }

    public static WxPayV3HttpClientBuilder create() {
        return new WxPayV3HttpClientBuilder();
    }

    public WxPayV3HttpClientBuilder withMerchant(String merchantId, String serialNo, PrivateKey privateKey) {
        this.credentials = new WxPayCredentials(merchantId, new PrivateKeySigner(serialNo, privateKey));
        return this;
    }

    public WxPayV3HttpClientBuilder withCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public WxPayV3HttpClientBuilder withWechatpay(List<X509Certificate> certificates) {
        this.validator = new WxPayValidator(new CertificatesVerifier(certificates));
        return this;
    }

    public WxPayV3HttpClientBuilder withValidator(Validator validator) {
        this.validator = validator;
        return this;
    }

    public CloseableHttpClient build() {
        if (this.credentials == null) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u8eab\u4efd\u8ba4\u8bc1\u4fe1\u606f");
        }
        if (this.validator == null) {
            throw new IllegalArgumentException("\u7f3a\u5c11\u7b7e\u540d\u9a8c\u8bc1\u4fe1\u606f");
        }
        return super.build();
    }

    protected ClientExecChain decorateProtocolExec(ClientExecChain requestExecutor) {
        return new SignatureExec(this.credentials, this.validator, requestExecutor);
    }
}

