/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Single;
import java.sql.Connection;
import javax.annotation.Nonnull;
import org.davidmoten.rx.jdbc.CallableBuilder;
import org.davidmoten.rx.jdbc.Database;
import org.davidmoten.rx.jdbc.SelectBuilder;
import org.davidmoten.rx.jdbc.TransactedCallableBuilder;
import org.davidmoten.rx.jdbc.TransactedConnection;
import org.davidmoten.rx.jdbc.TransactedSelectBuilder;
import org.davidmoten.rx.jdbc.TransactedUpdateBuilder;
import org.davidmoten.rx.jdbc.UpdateBuilder;

public final class TransactedBuilder {
    private final Single<Connection> connections;
    private final Database db;

    TransactedBuilder(TransactedConnection con, Database db) {
        this.db = db;
        this.connections = Single.just((Object)con);
    }

    public TransactedSelectBuilder select(@Nonnull String sql) {
        Preconditions.checkNotNull((Object)sql, (String)"sql cannot be null");
        return new SelectBuilder(sql, this.connections, this.db).transacted();
    }

    public TransactedUpdateBuilder update(@Nonnull String sql) {
        Preconditions.checkNotNull((Object)sql, (String)"sql cannot be null");
        return new UpdateBuilder(sql, this.connections, this.db).transacted();
    }

    public TransactedCallableBuilder call(@Nonnull String sql) {
        Preconditions.checkNotNull((Object)sql, (String)"sql cannot be null");
        return new CallableBuilder(sql, this.connections, this.db).transacted();
    }
}

