/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import io.reactivex.Flowable;
import io.reactivex.Single;
import java.sql.Connection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.davidmoten.rx.jdbc.Database;
import org.davidmoten.rx.jdbc.DependsOn;
import org.davidmoten.rx.jdbc.Getter;
import org.davidmoten.rx.jdbc.GetterTx;
import org.davidmoten.rx.jdbc.ResultSetMapper;
import org.davidmoten.rx.jdbc.Select;
import org.davidmoten.rx.jdbc.SelectBuilder;
import org.davidmoten.rx.jdbc.Tx;
import org.davidmoten.rx.jdbc.TxImpl;
import org.davidmoten.rx.jdbc.Util;

public final class TransactedSelectBuilder
implements DependsOn<TransactedSelectBuilder>,
GetterTx {
    private final SelectBuilder selectBuilder;
    private boolean valuesOnly = false;
    private final Database db;

    TransactedSelectBuilder(SelectBuilder selectBuilder, Database db) {
        this.selectBuilder = selectBuilder;
        this.db = db;
    }

    public TransactedSelectBuilder parameters(@Nonnull Flowable<List<Object>> parameters) {
        this.selectBuilder.parameters(parameters);
        return this;
    }

    public TransactedSelectBuilder parameters(@Nonnull List<?> values) {
        this.selectBuilder.parameters(values);
        return this;
    }

    public TransactedSelectBuilder parameter(@Nonnull String name, Object value) {
        this.selectBuilder.parameter(name, value);
        return this;
    }

    public TransactedSelectBuilder parameters(Object ... values) {
        this.selectBuilder.parameters(values);
        return this;
    }

    public TransactedSelectBuilder parameter(Object value) {
        return this.parameters(value);
    }

    public TransactedSelectBuilder fetchSize(int size) {
        this.selectBuilder.fetchSize(size);
        return this;
    }

    public TransactedSelectBuilder transactedValuesOnly() {
        this.valuesOnly = true;
        return this;
    }

    @Override
    public TransactedSelectBuilder dependsOn(@Nonnull Flowable<?> flowable) {
        this.selectBuilder.dependsOn((Flowable)flowable);
        return this;
    }

    public TransactedSelectBuilderValuesOnly valuesOnly() {
        return new TransactedSelectBuilderValuesOnly(this, this.db);
    }

    @Override
    public <T> Flowable<Tx<T>> get(ResultSetMapper<? extends T> function) {
        Flowable<Tx<? extends T>> o = TransactedSelectBuilder.createFlowable(this.selectBuilder, function, this.db);
        if (this.valuesOnly) {
            return o.filter(tx -> tx.isValue());
        }
        return o;
    }

    private static <T> Flowable<Tx<T>> createFlowable(SelectBuilder sb, ResultSetMapper<? extends T> mapper, Database db) {
        return Flowable.defer(() -> {
            AtomicReference connection = new AtomicReference();
            Single con = sb.connection.map(c -> Util.toTransactedConnection(connection, c));
            return Select.create((Single<Connection>)con, sb.parameterGroupsToFlowable(), sb.sql, sb.fetchSize, mapper, false).materialize().flatMap(n -> Tx.toTx(n, (Connection)connection.get(), db)).doOnNext(tx -> {
                if (tx.isComplete()) {
                    ((TxImpl)tx).connection().commit();
                }
            });
        });
    }

    public static final class TransactedSelectBuilderValuesOnly
    implements Getter {
        private final TransactedSelectBuilder b;
        private final Database db;

        TransactedSelectBuilderValuesOnly(TransactedSelectBuilder b, Database db) {
            this.b = b;
            this.db = db;
        }

        @Override
        public <T> Flowable<T> get(@Nonnull ResultSetMapper<? extends T> function) {
            return TransactedSelectBuilder.createFlowable(this.b.selectBuilder, function, this.db).flatMap(Tx.flattenToValuesOnly());
        }
    }
}

