/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import io.reactivex.Flowable;
import io.reactivex.Single;
import java.sql.Connection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.davidmoten.rx.jdbc.Database;
import org.davidmoten.rx.jdbc.DependsOn;
import org.davidmoten.rx.jdbc.TransactedReturnGeneratedKeysBuilder;
import org.davidmoten.rx.jdbc.Tx;
import org.davidmoten.rx.jdbc.TxImpl;
import org.davidmoten.rx.jdbc.Update;
import org.davidmoten.rx.jdbc.UpdateBuilder;
import org.davidmoten.rx.jdbc.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransactedUpdateBuilder
implements DependsOn<TransactedUpdateBuilder> {
    private static final Logger log = LoggerFactory.getLogger(TransactedUpdateBuilder.class);
    final UpdateBuilder updateBuilder;
    private final Database db;
    private boolean valuesOnly;

    TransactedUpdateBuilder(UpdateBuilder b, Database db) {
        this.updateBuilder = b;
        this.db = db;
    }

    public TransactedUpdateBuilder parameterStream(@Nonnull Flowable<?> values) {
        this.updateBuilder.parameterStream(values);
        return this;
    }

    public TransactedUpdateBuilder parameterListStream(@Nonnull Flowable<List<?>> valueLists) {
        this.updateBuilder.parameterListStream(valueLists);
        return this;
    }

    public TransactedUpdateBuilder parameters(@Nonnull List<?> values) {
        this.updateBuilder.parameters(values);
        return this;
    }

    public TransactedUpdateBuilder parameter(@Nonnull String name, Object value) {
        this.updateBuilder.parameter(name, value);
        return this;
    }

    public TransactedUpdateBuilder parameter(Object value) {
        return this.parameters(value);
    }

    public TransactedUpdateBuilder parameters(Object ... values) {
        this.updateBuilder.parameters(values);
        return this;
    }

    @Override
    public TransactedUpdateBuilder dependsOn(@Nonnull Flowable<?> dependency) {
        this.updateBuilder.dependsOn((Flowable)dependency);
        return this;
    }

    public TransactedUpdateBuilder batchSize(int batchSize) {
        this.updateBuilder.batchSize(batchSize);
        return this;
    }

    public TransactedReturnGeneratedKeysBuilder returnGeneratedKeys() {
        return new TransactedReturnGeneratedKeysBuilder(this, this.db);
    }

    public TransactedUpdateBuilder transactedValuesOnly() {
        this.valuesOnly = true;
        return this;
    }

    public TransactedUpdateBuilderValuesOnly valuesOnly() {
        return new TransactedUpdateBuilderValuesOnly(this, this.db);
    }

    public Flowable<Tx<Integer>> counts() {
        Flowable<Tx<Integer>> o = TransactedUpdateBuilder.createFlowable(this.updateBuilder, this.db);
        if (this.valuesOnly) {
            return o.filter(tx -> tx.isValue());
        }
        return o;
    }

    public Flowable<Integer> countsOnly() {
        return this.valuesOnly().counts();
    }

    public Flowable<Tx<?>> tx() {
        return TransactedUpdateBuilder.createFlowable(this.updateBuilder, this.db).filter(x -> x.isValue());
    }

    private static Flowable<Tx<Integer>> createFlowable(UpdateBuilder ub, Database db) {
        return Flowable.defer(() -> {
            log.debug("creating deferred flowable");
            AtomicReference connection = new AtomicReference();
            Single con = ub.connections.map(c -> Util.toTransactedConnection(connection, c));
            TxImpl[] t = new TxImpl[1];
            return ub.startWithDependency(Update.create((Single<Connection>)con, ub.parameterGroupsToFlowable(), ub.sql, ub.batchSize, false).flatMap(n -> Tx.toTx(n, (Connection)connection.get(), db)).doOnNext(tx -> {
                t[0] = (TxImpl)tx;
            }).doOnComplete(() -> {
                TxImpl tx = t[0];
                if (tx.isComplete()) {
                    tx.connection().commit();
                }
                Util.closeSilently(tx.connection());
            }));
        });
    }

    public Flowable<List<Object>> parameterGroupsToFlowable() {
        return this.updateBuilder.parameterGroupsToFlowable();
    }

    public static final class TransactedUpdateBuilderValuesOnly {
        private final TransactedUpdateBuilder b;
        private final Database db;

        TransactedUpdateBuilderValuesOnly(TransactedUpdateBuilder b, Database db) {
            this.b = b;
            this.db = db;
        }

        public Flowable<Integer> counts() {
            return TransactedUpdateBuilder.createFlowable(this.b.updateBuilder, this.db).flatMap(Tx.flattenToValuesOnly());
        }
    }
}

