/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import io.reactivex.Flowable;
import io.reactivex.Notification;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import java.sql.Connection;
import org.davidmoten.rx.jdbc.Database;
import org.davidmoten.rx.jdbc.TxImpl;
import org.davidmoten.rx.jdbc.TxWithoutValue;

public interface Tx<T>
extends TxWithoutValue {
    public boolean isValue();

    public T value();

    public static <T> Predicate<Tx<T>> valuesOnly() {
        return tx -> tx.isValue();
    }

    public static <T> Function<Tx<T>, Flowable<T>> flattenToValuesOnly() {
        return tx -> {
            if (tx.isValue()) {
                return Flowable.just(tx.value());
            }
            if (tx.isComplete()) {
                return Flowable.empty();
            }
            return Flowable.error((Throwable)tx.throwable());
        };
    }

    public static <T> Function<Tx<T>, T> toValue() {
        return tx -> tx.value();
    }

    public static <T> Flowable<Tx<T>> toTx(Notification<T> n, Connection con, Database db) {
        if (n.isOnComplete()) {
            return Flowable.just(new TxImpl<Object>(con, null, null, true, db));
        }
        if (n.isOnNext()) {
            return Flowable.just(new TxImpl<Object>(con, n.getValue(), null, false, db));
        }
        return Flowable.error((Throwable)n.getError());
    }
}

