/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Notification;
import io.reactivex.Single;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.Callable;
import org.davidmoten.rx.jdbc.NamedPreparedStatement;
import org.davidmoten.rx.jdbc.Parameter;
import org.davidmoten.rx.jdbc.Util;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Update {
    private static final Logger log = LoggerFactory.getLogger(Update.class);

    private Update() {
    }

    static Flowable<Notification<Integer>> create(Single<Connection> connection, Flowable<List<Object>> parameterGroups, String sql, int batchSize, boolean eagerDispose) {
        return connection.toFlowable().flatMap(con -> Update.create(con, sql, parameterGroups, batchSize, eagerDispose), true, 1);
    }

    private static Flowable<Notification<Integer>> create(Connection con, String sql, Flowable<List<Object>> parameterGroups, int batchSize, boolean eagerDispose) {
        log.debug("Update.create {}", (Object)sql);
        Callable<NamedPreparedStatement> resourceFactory = () -> Util.prepare(con, sql);
        Function flowableFactory = batchSize == 0 ? ps -> parameterGroups.flatMap(parameters -> Update.create(ps, Util.toParameters(parameters), sql).toFlowable()).materialize().doOnComplete(() -> Util.commit(ps.ps)).doOnError(e -> Util.rollback(ps.ps)) : ps -> {
            int[] count = new int[1];
            return parameterGroups.flatMap(parameters -> {
                Flowable<Integer> result;
                List<Parameter> params = Util.toParameters(parameters);
                if (Util.hasCollection(params)) {
                    return Update.create(ps, params, sql).toFlowable();
                }
                Util.incrementCounter(ps.ps.getConnection());
                count[0] = count[0] + 1;
                if (count[0] == batchSize) {
                    count[0] = 0;
                    result = Update.createExecuteBatch(ps, parameters);
                } else {
                    result = Update.createAddBatch(ps, parameters).toFlowable();
                }
                return result;
            }).materialize().flatMap(n -> Update.executeFinalBatch(ps, (Notification<Integer>)n, count[0] > 0)).doOnComplete(() -> Util.commit(ps.ps)).doOnError(e -> Util.rollback(ps.ps));
        };
        Consumer disposer = Util::closePreparedStatementAndConnection;
        return Flowable.using(resourceFactory, (Function)flowableFactory, (Consumer)disposer, (boolean)eagerDispose);
    }

    private static Flowable<Notification<Integer>> executeFinalBatch(NamedPreparedStatement ps, Notification<Integer> n, boolean outstandingBatch) throws SQLException {
        if (n.isOnComplete() && outstandingBatch) {
            log.debug("executing final batch");
            return Update.toFlowable(ps.ps.executeBatch()).map(x -> Notification.createOnNext((Object)x)).concatWith((Publisher)Flowable.just(n));
        }
        return Flowable.just(n);
    }

    private static Single<Integer> create(NamedPreparedStatement ps, List<Parameter> params, String sql) {
        return Single.fromCallable(() -> {
            Util.incrementCounter(ps.ps.getConnection());
            boolean hasCollection = Util.hasCollection(params);
            PreparedStatement ps2 = null;
            try {
                ps2 = hasCollection ? Util.prepare(ps.ps.getConnection(), 0, sql, params) : ps.ps;
                Util.setParameters(ps2, params, ps.names);
                return ps2.executeUpdate();
            }
            catch (Throwable e) {
                if (hasCollection && ps2 != null) {
                    ps2.close();
                }
                throw e;
            }
        });
    }

    private static Flowable<Integer> createExecuteBatch(NamedPreparedStatement ps, List<Object> parameters) {
        return Flowable.defer(() -> {
            Util.convertAndSetParameters(ps.ps, parameters, ps.names);
            ps.ps.addBatch();
            log.debug("batch added with {}", (Object)parameters);
            Flowable<Integer> o = Update.toFlowable(ps.ps.executeBatch());
            log.debug("batch executed");
            return o;
        });
    }

    private static Flowable<Integer> toFlowable(int[] a) {
        return Flowable.range((int)0, (int)a.length).map(i -> a[i]);
    }

    private static Completable createAddBatch(NamedPreparedStatement ps, List<Object> parameters) {
        return Completable.fromAction(() -> {
            Util.convertAndSetParameters(ps.ps, parameters, ps.names);
            ps.ps.addBatch();
            log.debug("batch added with {}", (Object)parameters);
        });
    }

    static <T> Flowable<T> createReturnGeneratedKeys(Single<Connection> connection, Flowable<List<Object>> parameterGroups, String sql, Function<? super ResultSet, ? extends T> mapper, boolean eagerDispose) {
        return connection.toFlowable().flatMap(con -> Update.createReturnGeneratedKeys(con, parameterGroups, sql, mapper, eagerDispose), true, 1);
    }

    private static <T> Flowable<T> createReturnGeneratedKeys(Connection con, Flowable<List<Object>> parameterGroups, String sql, Function<? super ResultSet, T> mapper, boolean eagerDispose) {
        Callable<NamedPreparedStatement> resourceFactory = () -> Util.prepareReturnGeneratedKeys(con, sql);
        Function obsFactory = ps -> parameterGroups.flatMap(parameters -> Update.create(ps, parameters, mapper), true, 1).doOnComplete(() -> Util.commit(ps.ps)).doOnError(e -> Util.rollback(ps.ps));
        Consumer disposer = Util::closePreparedStatementAndConnection;
        return Flowable.using(resourceFactory, (Function)obsFactory, (Consumer)disposer, (boolean)eagerDispose);
    }

    private static <T> Flowable<T> create(NamedPreparedStatement ps, List<Object> parameters, Function<? super ResultSet, T> mapper) {
        Callable<ResultSet> initialState = () -> {
            Util.convertAndSetParameters(ps.ps, parameters, ps.names);
            ps.ps.execute();
            return ps.ps.getGeneratedKeys();
        };
        BiConsumer generator = (rs, emitter) -> {
            if (rs.next()) {
                emitter.onNext(mapper.apply(rs));
            } else {
                emitter.onComplete();
            }
        };
        Consumer disposer = Util::closeSilently;
        return Flowable.generate(initialState, (BiConsumer)generator, (Consumer)disposer);
    }
}

