/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.davidmoten.rx.jdbc.ConnectionProvider;
import org.davidmoten.rx.jdbc.Database;
import org.davidmoten.rx.jdbc.NamedCallableStatement;
import org.davidmoten.rx.jdbc.NamedPreparedStatement;
import org.davidmoten.rx.jdbc.Parameter;
import org.davidmoten.rx.jdbc.ResultSetMapper;
import org.davidmoten.rx.jdbc.SqlInfo;
import org.davidmoten.rx.jdbc.TransactedConnection;
import org.davidmoten.rx.jdbc.Type;
import org.davidmoten.rx.jdbc.annotations.Column;
import org.davidmoten.rx.jdbc.annotations.Index;
import org.davidmoten.rx.jdbc.callable.internal.OutParameterPlaceholder;
import org.davidmoten.rx.jdbc.callable.internal.ParameterPlaceholder;
import org.davidmoten.rx.jdbc.exceptions.AnnotationsNotFoundException;
import org.davidmoten.rx.jdbc.exceptions.AutomappedInterfaceInaccessibleException;
import org.davidmoten.rx.jdbc.exceptions.ColumnIndexOutOfRangeException;
import org.davidmoten.rx.jdbc.exceptions.ColumnNotFoundException;
import org.davidmoten.rx.jdbc.exceptions.MoreColumnsRequestedThanExistException;
import org.davidmoten.rx.jdbc.exceptions.NamedParameterFoundButSqlDoesNotHaveNamesException;
import org.davidmoten.rx.jdbc.exceptions.NamedParameterMissingException;
import org.davidmoten.rx.jdbc.exceptions.ParameterMissingNameException;
import org.davidmoten.rx.jdbc.exceptions.SQLRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Util {

    private static final Logger log = LoggerFactory.getLogger(Util.class);

    @VisibleForTesting
    static void setParameters(PreparedStatement ps, List<Parameter> params, boolean namesAllowed) throws SQLException {
        int j = 1;
        for (int i = 0; i < params.size(); ++i) {
            Parameter p = params.get(i);
            if (p.hasName() && !namesAllowed) {
                throw new NamedParameterFoundButSqlDoesNotHaveNamesException("named parameter found but sql does not contain names ps=" + ps);
            }
            Object v = p.value();
            if (p.isCollection()) {
                for (Object o : (Collection)v) {
                    Util.setParameter(ps, j, o);
                    ++j;
                }
                continue;
            }
            Util.setParameter(ps, j, v);
            ++j;
        }
    }

    static void setParameter(PreparedStatement ps, int i, Object o) throws SQLException {
        log.debug("setting parameter {} to {}", (Object)i, o);
        try {
            if (o == null) {
                ps.setObject(i, null);
            } else if (o == Database.NULL_CLOB) {
                ps.setNull(i, 2005);
            } else if (o == Database.NULL_BLOB) {
                ps.setNull(i, 2004);
            } else {
                Class<?> cls = o.getClass();
                if (Clob.class.isAssignableFrom(cls)) {
                    Util.setClob(ps, i, o, cls);
                } else if (Blob.class.isAssignableFrom(cls)) {
                    Util.setBlob(ps, i, o, cls);
                } else if (Calendar.class.isAssignableFrom(cls)) {
                    Calendar cal = (Calendar)o;
                    Timestamp t = new Timestamp(cal.getTimeInMillis());
                    ps.setTimestamp(i, t);
                } else if (Time.class.isAssignableFrom(cls)) {
                    Calendar cal = Calendar.getInstance();
                    ps.setTime(i, (Time)o, cal);
                } else if (Timestamp.class.isAssignableFrom(cls)) {
                    Calendar cal = Calendar.getInstance();
                    ps.setTimestamp(i, (Timestamp)o, cal);
                } else if (Date.class.isAssignableFrom(cls)) {
                    ps.setDate(i, (Date)o, Calendar.getInstance());
                } else if (java.util.Date.class.isAssignableFrom(cls)) {
                    Calendar cal = Calendar.getInstance();
                    java.util.Date date = (java.util.Date)o;
                    ps.setTimestamp(i, new Timestamp(date.getTime()), cal);
                } else if (Instant.class.isAssignableFrom(cls)) {
                    Calendar cal = Calendar.getInstance();
                    Instant instant = (Instant)o;
                    ps.setTimestamp(i, new Timestamp(instant.toEpochMilli()), cal);
                } else if (ZonedDateTime.class.isAssignableFrom(cls)) {
                    Calendar cal = Calendar.getInstance();
                    ZonedDateTime d = (ZonedDateTime)o;
                    ps.setTimestamp(i, new Timestamp(d.toInstant().toEpochMilli()), cal);
                } else {
                    ps.setObject(i, o);
                }
            }
        }
        catch (SQLException e) {
            log.debug("{} when setting ps.setObject({},{})", new Object[]{e.getMessage(), i, o});
            throw e;
        }
    }

    private static void setBlob(PreparedStatement ps, int i, Object o, Class<?> cls) throws SQLException {
        ps.setBlob(i, (Blob)o);
    }

    private static void setClob(PreparedStatement ps, int i, Object o, Class<?> cls) throws SQLException {
        ps.setClob(i, (Clob)o);
    }

    static void setNamedParameters(PreparedStatement ps, List<Parameter> parameters, List<String> names) throws SQLException {
        Map<String, Parameter> map = Util.createMap(parameters);
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (String name : names) {
            if (!map.containsKey(name)) {
                throw new NamedParameterMissingException("named parameter is missing for '" + name + "'");
            }
            Parameter p = map.get(name);
            list.add(p);
        }
        Util.setParameters(ps, list, true);
    }

    @VisibleForTesting
    static Map<String, Parameter> createMap(List<Parameter> parameters) {
        HashMap<String, Parameter> map = new HashMap<String, Parameter>();
        for (Parameter p : parameters) {
            if (p.hasName()) {
                map.put(p.name(), p);
                continue;
            }
            throw new ParameterMissingNameException("named parameters were expected but this parameter did not have a name: " + p);
        }
        return map;
    }

    static PreparedStatement convertAndSetParameters(PreparedStatement ps, List<Object> parameters, List<String> names) throws SQLException {
        return Util.setParameters(ps, Util.toParameters(parameters), names);
    }

    static PreparedStatement setParameters(PreparedStatement ps, List<Parameter> parameters, List<String> names) throws SQLException {
        if (names.isEmpty()) {
            Util.setParameters(ps, parameters, false);
        } else {
            Util.setNamedParameters(ps, parameters, names);
        }
        return ps;
    }

    static List<Parameter> toParameters(List<Object> parameters) {
        return parameters.stream().map(o -> {
            if (o instanceof Parameter) {
                return (Parameter)o;
            }
            return new Parameter(o);
        }).collect(Collectors.toList());
    }

    static void incrementCounter(Connection connection) {
        if (connection instanceof TransactedConnection) {
            TransactedConnection c = (TransactedConnection)connection;
            c.incrementCounter();
        }
    }

    public static void closeSilently(AutoCloseable c) {
        if (c != null) {
            try {
                log.debug("closing {}", (Object)c);
                c.close();
            }
            catch (Exception e) {
                log.debug("ignored exception {}, {}, {}", new Object[]{e.getMessage(), e.getClass(), e});
            }
        }
    }

    static void closePreparedStatementAndConnection(PreparedStatement ps) {
        Connection con = null;
        try {
            con = ps.getConnection();
        }
        catch (SQLException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        Util.closeSilently(ps);
        Util.closeSilently(con);
    }

    static void closePreparedStatementAndConnection(NamedPreparedStatement ps) {
        Util.closePreparedStatementAndConnection(ps.ps);
    }

    static void closeCallableStatementAndConnection(NamedCallableStatement stmt) {
        Util.closePreparedStatementAndConnection(stmt.stmt);
    }

    static NamedPreparedStatement prepare(Connection con, String sql) throws SQLException {
        return Util.prepare(con, 0, sql);
    }

    static NamedPreparedStatement prepare(Connection con, int fetchSize, String sql) throws SQLException {
        SqlInfo info = SqlInfo.parse(sql);
        log.debug("preparing statement: {}", (Object)sql);
        return Util.prepare(con, fetchSize, info);
    }

    static PreparedStatement prepare(Connection connection, int fetchSize, String sql, List<Parameter> parameters) throws SQLException {
        SqlInfo info = SqlInfo.parse(sql, parameters);
        log.debug("preparing statement: {}", (Object)info.sql());
        return Util.createPreparedStatement(connection, fetchSize, info);
    }

    private static NamedPreparedStatement prepare(Connection con, int fetchSize, SqlInfo info) throws SQLException {
        PreparedStatement ps = Util.createPreparedStatement(con, fetchSize, info);
        return new NamedPreparedStatement(ps, info.names());
    }

    private static PreparedStatement createPreparedStatement(Connection con, int fetchSize, SqlInfo info) throws SQLException {
        Statement ps = null;
        try {
            ps = con.prepareStatement(info.sql(), 1003, 1007);
            if (fetchSize > 0) {
                ps.setFetchSize(fetchSize);
            }
        }
        catch (RuntimeException | SQLException e) {
            if (ps != null) {
                ps.close();
            }
            throw e;
        }
        return ps;
    }

    static NamedCallableStatement prepareCall(Connection con, String sql, List<ParameterPlaceholder> parameterPlaceholders) throws SQLException {
        return Util.prepareCall(con, 0, sql, parameterPlaceholders);
    }

    static NamedCallableStatement prepareCall(Connection con, int fetchSize, String sql, List<ParameterPlaceholder> parameterPlaceholders) throws SQLException {
        SqlInfo s = SqlInfo.parse(sql);
        log.debug("preparing statement: {}", (Object)sql);
        Statement ps = null;
        try {
            ps = con.prepareCall(s.sql(), 1003, 1007);
            for (int i = 0; i < parameterPlaceholders.size(); ++i) {
                ParameterPlaceholder p = parameterPlaceholders.get(i);
                if (!(p instanceof OutParameterPlaceholder)) continue;
                ps.registerOutParameter(i + 1, ((OutParameterPlaceholder)p).type().value());
            }
            if (fetchSize > 0) {
                ps.setFetchSize(fetchSize);
            }
            return new NamedCallableStatement((CallableStatement)ps, s.names());
        }
        catch (RuntimeException | SQLException e) {
            if (ps != null) {
                ps.close();
            }
            throw e;
        }
    }

    static NamedPreparedStatement prepareReturnGeneratedKeys(Connection con, String sql) throws SQLException {
        SqlInfo s = SqlInfo.parse(sql);
        return new NamedPreparedStatement(con.prepareStatement(s.sql(), 1), s.names());
    }

    @VisibleForTesting
    static int countQuestionMarkParameters(String sql) {
        int count = 0;
        int length = sql.length();
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        for (int i = 0; i < length; ++i) {
            char c = sql.charAt(i);
            if (inSingleQuote) {
                if (c != '\'') continue;
                inSingleQuote = false;
                continue;
            }
            if (inDoubleQuote) {
                if (c != '\"') continue;
                inDoubleQuote = false;
                continue;
            }
            if (c == '\'') {
                inSingleQuote = true;
                continue;
            }
            if (c == '\"') {
                inDoubleQuote = true;
                continue;
            }
            if (c != '?') continue;
            ++count;
        }
        return count;
    }

    public static void commit(PreparedStatement ps) throws SQLException {
        Connection c = ps.getConnection();
        if (!c.getAutoCommit()) {
            c.commit();
        }
    }

    public static void rollback(PreparedStatement ps) throws SQLException {
        Connection c = ps.getConnection();
        if (!c.getAutoCommit()) {
            c.rollback();
        }
    }

    public static Object autoMap(Object o, Class<?> cls) {
        if (o == null) {
            return o;
        }
        if (cls.isAssignableFrom(o.getClass())) {
            return o;
        }
        if (o instanceof Date) {
            Date d = (Date)o;
            if (cls.isAssignableFrom(Long.class)) {
                return d.getTime();
            }
            if (cls.isAssignableFrom(BigInteger.class)) {
                return BigInteger.valueOf(d.getTime());
            }
            if (cls.isAssignableFrom(Instant.class)) {
                return Instant.ofEpochMilli(d.getTime());
            }
            return o;
        }
        if (o instanceof Timestamp) {
            Timestamp t = (Timestamp)o;
            if (cls.isAssignableFrom(Long.class)) {
                return t.getTime();
            }
            if (cls.isAssignableFrom(BigInteger.class)) {
                return BigInteger.valueOf(t.getTime());
            }
            if (cls.isAssignableFrom(Instant.class)) {
                return t.toInstant();
            }
            return o;
        }
        if (o instanceof Time) {
            Time t = (Time)o;
            if (cls.isAssignableFrom(Long.class)) {
                return t.getTime();
            }
            if (cls.isAssignableFrom(BigInteger.class)) {
                return BigInteger.valueOf(t.getTime());
            }
            if (cls.isAssignableFrom(Instant.class)) {
                return t.toInstant();
            }
            return o;
        }
        if (o instanceof Blob && cls.isAssignableFrom(byte[].class)) {
            return Util.toBytes((Blob)o);
        }
        if (o instanceof Clob && cls.isAssignableFrom(String.class)) {
            return Util.toString((Clob)o);
        }
        if (o instanceof BigInteger && cls.isAssignableFrom(Long.class)) {
            return ((BigInteger)o).longValue();
        }
        if (o instanceof BigInteger && cls.isAssignableFrom(Integer.class)) {
            return ((BigInteger)o).intValue();
        }
        if (o instanceof BigInteger && cls.isAssignableFrom(Double.class)) {
            return ((BigInteger)o).doubleValue();
        }
        if (o instanceof BigInteger && cls.isAssignableFrom(Float.class)) {
            return Float.valueOf(((BigInteger)o).floatValue());
        }
        if (o instanceof BigInteger && cls.isAssignableFrom(Short.class)) {
            return ((BigInteger)o).shortValue();
        }
        if (o instanceof BigInteger && cls.isAssignableFrom(BigDecimal.class)) {
            return new BigDecimal((BigInteger)o);
        }
        if (o instanceof BigDecimal && cls.isAssignableFrom(Double.class)) {
            return ((BigDecimal)o).doubleValue();
        }
        if (o instanceof BigDecimal && cls.isAssignableFrom(Integer.class)) {
            return ((BigDecimal)o).toBigInteger().intValue();
        }
        if (o instanceof BigDecimal && cls.isAssignableFrom(Float.class)) {
            return Float.valueOf(((BigDecimal)o).floatValue());
        }
        if (o instanceof BigDecimal && cls.isAssignableFrom(Short.class)) {
            return ((BigDecimal)o).toBigInteger().shortValue();
        }
        if (o instanceof BigDecimal && cls.isAssignableFrom(Long.class)) {
            return ((BigDecimal)o).toBigInteger().longValue();
        }
        if (o instanceof BigDecimal && cls.isAssignableFrom(BigInteger.class)) {
            return ((BigDecimal)o).toBigInteger();
        }
        if ((o instanceof Short || o instanceof Integer || o instanceof Long) && cls.isAssignableFrom(BigInteger.class)) {
            return new BigInteger(o.toString());
        }
        if (o instanceof Number && cls.isAssignableFrom(BigDecimal.class)) {
            return new BigDecimal(o.toString());
        }
        if (o instanceof Number && cls.isAssignableFrom(Short.class)) {
            return ((Number)o).shortValue();
        }
        if (o instanceof Number && cls.isAssignableFrom(Integer.class)) {
            return ((Number)o).intValue();
        }
        if (o instanceof Number && cls.isAssignableFrom(Integer.class)) {
            return ((Number)o).intValue();
        }
        if (o instanceof Number && cls.isAssignableFrom(Long.class)) {
            return ((Number)o).longValue();
        }
        if (o instanceof Number && cls.isAssignableFrom(Float.class)) {
            return Float.valueOf(((Number)o).floatValue());
        }
        if (o instanceof Number && cls.isAssignableFrom(Double.class)) {
            return ((Number)o).doubleValue();
        }
        return o;
    }

    public static <T> T mapObject(ResultSet rs, Class<T> cls, int i) {
        return (T)Util.autoMap(Util.getObject(rs, cls, i), cls);
    }

    public static <T> T mapObject(CallableStatement cs, Class<T> cls, int i, Type type) {
        return (T)Util.autoMap(Util.getObject(cs, cls, i, type), cls);
    }

    private static <T> Object getObject(ResultSet rs, Class<T> cls, int i) {
        try {
            int colCount = rs.getMetaData().getColumnCount();
            if (i > colCount) {
                throw new MoreColumnsRequestedThanExistException("only " + colCount + " columns exist in ResultSet and column " + i + " was requested");
            }
            if (rs.getObject(i) == null) {
                return null;
            }
            int type = rs.getMetaData().getColumnType(i);
            if (type == 91) {
                return rs.getDate(i, Calendar.getInstance());
            }
            if (type == 92) {
                return rs.getTime(i, Calendar.getInstance());
            }
            if (type == 93) {
                return rs.getTimestamp(i, Calendar.getInstance());
            }
            if (type == 2005 && cls.equals(String.class)) {
                return Util.toString(rs.getClob(i));
            }
            if (type == 2005 && Reader.class.isAssignableFrom(cls)) {
                Clob c = rs.getClob(i);
                Reader r = c.getCharacterStream();
                return Util.createFreeOnCloseReader(c, r);
            }
            if (type == 2004 && cls.equals(byte[].class)) {
                return Util.toBytes(rs.getBlob(i));
            }
            if (type == 2004 && InputStream.class.isAssignableFrom(cls)) {
                Blob b = rs.getBlob(i);
                InputStream is = rs.getBlob(i).getBinaryStream();
                return Util.createFreeOnCloseInputStream(b, is);
            }
            return rs.getObject(i);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    private static <T> Object getObject(CallableStatement cs, Class<T> cls, int i, Type typ) {
        try {
            if (cs.getObject(i) == null) {
                return null;
            }
            int type = typ.value();
            if (type == 91) {
                return cs.getDate(i, Calendar.getInstance());
            }
            if (type == 92) {
                return cs.getTime(i, Calendar.getInstance());
            }
            if (type == 93) {
                return cs.getTimestamp(i, Calendar.getInstance());
            }
            if (type == 2005 && cls.equals(String.class)) {
                return Util.toString(cs.getClob(i));
            }
            if (type == 2005 && Reader.class.isAssignableFrom(cls)) {
                Clob c = cs.getClob(i);
                Reader r = c.getCharacterStream();
                return Util.createFreeOnCloseReader(c, r);
            }
            if (type == 2004 && cls.equals(byte[].class)) {
                return Util.toBytes(cs.getBlob(i));
            }
            if (type == 2004 && InputStream.class.isAssignableFrom(cls)) {
                Blob b = cs.getBlob(i);
                InputStream is = cs.getBlob(i).getBinaryStream();
                return Util.createFreeOnCloseInputStream(b, is);
            }
            return cs.getObject(i);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @VisibleForTesting
    static byte[] toBytes(Blob b) {
        try {
            InputStream is = b.getBinaryStream();
            byte[] result = IOUtils.toByteArray((InputStream)is);
            is.close();
            b.free();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @VisibleForTesting
    static String toString(Clob c) {
        try {
            Reader reader = c.getCharacterStream();
            String result = IOUtils.toString((Reader)reader);
            reader.close();
            c.free();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    private static InputStream createFreeOnCloseInputStream(final Blob blob, final InputStream is) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return is.read();
            }

            @Override
            public void close() throws IOException {
                try {
                    is.close();
                }
                finally {
                    try {
                        blob.free();
                    }
                    catch (SQLException e) {
                        log.debug(e.getMessage());
                    }
                }
            }
        };
    }

    private static Reader createFreeOnCloseReader(final Clob clob, final Reader reader) {
        return new Reader(){

            @Override
            public void close() throws IOException {
                try {
                    reader.close();
                }
                finally {
                    try {
                        clob.free();
                    }
                    catch (SQLException e) {
                        log.debug(e.getMessage());
                    }
                }
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                return reader.read(cbuf, off, len);
            }
        };
    }

    static <T> ResultSetMapper<T> autoMap(final Class<T> cls) {
        return new ResultSetMapper<T>(){
            ProxyService<T> proxyService;
            private ResultSet rs;

            @Override
            public T apply(ResultSet rs) {
                if (rs != this.rs) {
                    this.rs = rs;
                    this.proxyService = new ProxyService(rs, cls);
                }
                return Util.autoMap(rs, cls, this.proxyService);
            }
        };
    }

    static <T> T autoMap(ResultSet rs, Class<T> cls, ProxyService<T> proxyService) {
        return proxyService.newInstance();
    }

    private static int getColumnCount(ResultSet rs) {
        try {
            return rs.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    @VisibleForTesting
    static boolean isHashCode(Method method, Object[] args) {
        return "hashCode".equals(method.getName()) && Util.isEmpty(args);
    }

    private static boolean isEmpty(Object[] args) {
        return args == null || args.length == 0;
    }

    private static String toString(String clsSimpleName, Map<String, Object> values) {
        StringBuilder s = new StringBuilder();
        s.append(clsSimpleName);
        s.append("[");
        boolean first = true;
        for (Map.Entry<String, Object> entry : new TreeMap<String, Object>(values).entrySet()) {
            if (!first) {
                s.append(", ");
            }
            s.append(entry.getKey());
            s.append("=");
            s.append(entry.getValue());
            first = false;
        }
        s.append("]");
        return s.toString();
    }

    private static Map<String, Col> getMethodCols(Class<?> cls) {
        HashMap<String, Col> methodCols = new HashMap<String, Col>();
        for (Method method : cls.getMethods()) {
            String name = method.getName();
            Column column = method.getAnnotation(Column.class);
            if (column != null) {
                Util.checkHasNoParameters(method);
                String col = column.value();
                if (col.equals("*COLUMN_NOT_SPECIFIED*")) {
                    col = Util.camelCaseToUnderscore(name);
                }
                methodCols.put(name, new NamedCol(col, method.getReturnType()));
                continue;
            }
            Index index = method.getAnnotation(Index.class);
            if (index == null) continue;
            Util.checkHasNoParameters(method);
            methodCols.put(name, new IndexedCol(index.value(), method.getReturnType()));
        }
        return methodCols;
    }

    private static void checkHasNoParameters(Method method) {
        if (method.getParameterTypes().length > 0) {
            throw new RuntimeException("mapped interface method cannot have parameters");
        }
    }

    private static Map<String, Integer> collectColIndexes(ResultSet rs) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            ResultSetMetaData metadata = rs.getMetaData();
            for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                map.put(metadata.getColumnName(i).toUpperCase(), i);
            }
            return map;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    static String camelCaseToUnderscore(String camelCased) {
        String regex = "([a-z])([A-Z]+)";
        String replacement = "$1_$2";
        return camelCased.replaceAll("([a-z])([A-Z]+)", "$1_$2");
    }

    public static ConnectionProvider connectionProvider(final String url, final Properties properties) {
        return new ConnectionProvider(){

            @Override
            public Connection get() {
                try {
                    return DriverManager.getConnection(url, properties);
                }
                catch (SQLException e) {
                    throw new SQLRuntimeException(e);
                }
            }

            @Override
            public void close() {
            }
        };
    }

    static Connection toTransactedConnection(AtomicReference<Connection> connection, Connection c) throws SQLException {
        if (c instanceof TransactedConnection) {
            connection.set(c);
            return c;
        }
        c.setAutoCommit(false);
        log.debug("creating new TransactedConnection");
        TransactedConnection c2 = new TransactedConnection(c);
        connection.set(c2);
        return c2;
    }

    public static ConnectionProvider connectionProvider(final DataSource dataSource) {
        return new ConnectionProvider(){

            @Override
            public Connection get() {
                return Util.getConnection(dataSource);
            }

            @Override
            public void close() {
            }
        };
    }

    @VisibleForTesting
    static Connection getConnection(DataSource ds) {
        try {
            return ds.getConnection();
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }

    public static boolean hasCollection(List<Parameter> params) {
        return params.stream().anyMatch(x -> x.isCollection());
    }

    private static final class ProxyInstance<T>
    implements InvocationHandler {
        private static boolean JAVA_9 = false;
        private static final String METHOD_TO_STRING = "toString";
        private final Class<T> cls;
        private final Map<String, Object> values;

        ProxyInstance(Class<T> cls, Map<String, Object> values) {
            this.cls = cls;
            this.values = values;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (METHOD_TO_STRING.equals(method.getName()) && Util.isEmpty(args)) {
                return Util.toString(this.cls.getSimpleName(), this.values);
            }
            if ("equals".equals(method.getName()) && args != null && args.length == 1) {
                if (args[0] == null) {
                    return false;
                }
                if (args[0] instanceof Proxy) {
                    ProxyInstance handler = (ProxyInstance)Proxy.getInvocationHandler(args[0]);
                    if (!handler.cls.equals(this.cls)) {
                        return false;
                    }
                    return handler.values.equals(this.values);
                }
                return false;
            }
            if (Util.isHashCode(method, args)) {
                return this.values.hashCode();
            }
            if (this.values.containsKey(method.getName()) && Util.isEmpty(args)) {
                return this.values.get(method.getName());
            }
            if (method.isDefault()) {
                Class<?> declaringClass = method.getDeclaringClass();
                if (!Modifier.isPublic(declaringClass.getModifiers())) {
                    throw new AutomappedInterfaceInaccessibleException("An automapped interface must be public for you to call default methods on that interface");
                }
                if (JAVA_9) {
                    MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
                    return MethodHandles.lookup().findSpecial(declaringClass, method.getName(), methodType, declaringClass).bindTo(proxy).invoke(args);
                }
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                constructor.setAccessible(true);
                return ((MethodHandles.Lookup)constructor.newInstance(declaringClass, 2)).unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(args);
            }
            throw new RuntimeException("unexpected");
        }
    }

    private static class ProxyService<T> {
        private final Map<String, Integer> colIndexes;
        private final Map<String, Col> methodCols;
        private final Class<T> cls;
        private final ResultSet rs;

        public ProxyService(ResultSet rs, Class<T> cls) {
            this(rs, Util.collectColIndexes(rs), Util.getMethodCols(cls), cls);
        }

        public ProxyService(ResultSet rs, Map<String, Integer> colIndexes, Map<String, Col> methodCols, Class<T> cls) {
            this.rs = rs;
            this.colIndexes = colIndexes;
            this.methodCols = methodCols;
            this.cls = cls;
        }

        private Map<String, Object> values() {
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (Method m : this.cls.getMethods()) {
                Integer index;
                String methodName = m.getName();
                Col column = this.methodCols.get(methodName);
                if (column == null) continue;
                if (column instanceof NamedCol) {
                    String name = ((NamedCol)column).name;
                    index = this.colIndexes.get(name.toUpperCase());
                    if (index == null) {
                        throw new ColumnNotFoundException("query column names do not include '" + name + "' which is a named column in the automapped interface " + this.cls.getName());
                    }
                } else {
                    IndexedCol col = (IndexedCol)column;
                    index = col.index;
                    if (index < 1) {
                        throw new ColumnIndexOutOfRangeException("value for Index annotation (on autoMapped interface " + this.cls.getName() + ") must be > 0");
                    }
                    int count = Util.getColumnCount(this.rs);
                    if (index > count) {
                        throw new ColumnIndexOutOfRangeException("value " + index + " for Index annotation (on autoMapped interface " + this.cls.getName() + ") must be between 1 and the number of columns in the result set (" + count + ")");
                    }
                }
                Object value = Util.autoMap(Util.getObject(this.rs, column.returnType(), index), column.returnType());
                values.put(methodName, value);
            }
            if (values.isEmpty()) {
                throw new AnnotationsNotFoundException("Did you forget to add @Column or @Index annotations to " + this.cls.getName() + "?");
            }
            return values;
        }

        public T newInstance() {
            return (T)Proxy.newProxyInstance(this.cls.getClassLoader(), new Class[]{this.cls}, new ProxyInstance<T>(this.cls, this.values()));
        }
    }

    static class IndexedCol
    implements Col {
        final int index;
        private final Class<?> returnType;

        public IndexedCol(int index, Class<?> returnType) {
            this.index = index;
            this.returnType = returnType;
        }

        @Override
        public Class<?> returnType() {
            return this.returnType;
        }
    }

    static class NamedCol
    implements Col {
        final String name;
        private final Class<?> returnType;

        public NamedCol(String name, Class<?> returnType) {
            this.name = name;
            this.returnType = returnType;
        }

        @Override
        public Class<?> returnType() {
            return this.returnType;
        }
    }

    static interface Col {
        public Class<?> returnType();
    }
}

