/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco;

import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.ResponseSetting;
import com.github.dreamhead.moco.Setting;
import com.github.dreamhead.moco.handler.failover.Failover;
import com.github.dreamhead.moco.handler.proxy.ProxyConfig;
import com.github.dreamhead.moco.mount.MountHandler;
import com.github.dreamhead.moco.mount.MountMatcher;
import com.github.dreamhead.moco.mount.MountPredicate;
import com.github.dreamhead.moco.mount.MountTo;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.netty.handler.codec.http.HttpMethod;
import java.io.File;

public abstract class HttpServer
extends ResponseSetting {
    public abstract int port();

    protected abstract Setting onRequestAttached(RequestMatcher var1);

    public Setting request(RequestMatcher matcher) {
        return this.onRequestAttached((RequestMatcher)Preconditions.checkNotNull((Object)matcher, (Object)"Matcher should not be null"));
    }

    public Setting request(RequestMatcher ... matchers) {
        return this.request(Moco.or(matchers));
    }

    public Setting get(RequestMatcher matcher) {
        return this.requestByHttpMethod(HttpMethod.GET, (RequestMatcher)Preconditions.checkNotNull((Object)matcher, (Object)"Matcher should not be null"));
    }

    public Setting post(RequestMatcher matcher) {
        return this.requestByHttpMethod(HttpMethod.POST, (RequestMatcher)Preconditions.checkNotNull((Object)matcher, (Object)"Matcher should not be null"));
    }

    public Setting put(RequestMatcher matcher) {
        return this.requestByHttpMethod(HttpMethod.PUT, (RequestMatcher)Preconditions.checkNotNull((Object)matcher, (Object)"Matcher should not be null"));
    }

    public Setting delete(RequestMatcher matcher) {
        return this.requestByHttpMethod(HttpMethod.DELETE, (RequestMatcher)Preconditions.checkNotNull((Object)matcher, (Object)"Matcher should not be null"));
    }

    public ResponseSetting mount(String dir, MountTo target, MountPredicate ... predicates) {
        File mountedDir = new File((String)Preconditions.checkNotNull((Object)dir, (Object)"Directory should not be null"));
        Preconditions.checkNotNull((Object)target, (Object)"Target should not be null");
        this.request((RequestMatcher)new MountMatcher(mountedDir, target, (Iterable<MountPredicate>)ImmutableList.copyOf((Object[])predicates))).response((ResponseHandler)new MountHandler(mountedDir, target));
        return this;
    }

    private Setting requestByHttpMethod(HttpMethod method, RequestMatcher matcher) {
        return this.request(Moco.and(Moco.by(Moco.method(method.name())), matcher));
    }

    public ResponseSetting proxy(ProxyConfig config) {
        return this.proxy((ProxyConfig)Preconditions.checkNotNull((Object)config), Failover.DEFAULT_FAILOVER);
    }

    public ResponseSetting proxy(ProxyConfig proxyConfig, Failover failover) {
        ProxyConfig config = (ProxyConfig)Preconditions.checkNotNull((Object)proxyConfig);
        this.request(HttpServer.context(config.localBase())).response(Moco.proxy(config, (Failover)Preconditions.checkNotNull((Object)failover)));
        return this;
    }
}

