/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco;

import com.github.dreamhead.moco.HttpServer;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoEvent;
import com.github.dreamhead.moco.MocoEventAction;
import com.github.dreamhead.moco.MocoEventTrigger;
import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.MocoProcedure;
import com.github.dreamhead.moco.RequestExtractor;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.action.MocoAsyncAction;
import com.github.dreamhead.moco.action.MocoRequestAction;
import com.github.dreamhead.moco.config.MocoContextConfig;
import com.github.dreamhead.moco.config.MocoFileRootConfig;
import com.github.dreamhead.moco.config.MocoResponseConfig;
import com.github.dreamhead.moco.extractor.CookieRequestExtractor;
import com.github.dreamhead.moco.extractor.Extractors;
import com.github.dreamhead.moco.extractor.FormRequestExtractor;
import com.github.dreamhead.moco.extractor.HeaderRequestExtractor;
import com.github.dreamhead.moco.extractor.JsonPathRequestExtractor;
import com.github.dreamhead.moco.extractor.ParamRequestExtractor;
import com.github.dreamhead.moco.extractor.XPathRequestExtractor;
import com.github.dreamhead.moco.handler.HeaderResponseHandler;
import com.github.dreamhead.moco.handler.ProcedureResponseHandler;
import com.github.dreamhead.moco.handler.ProxyBatchResponseHandler;
import com.github.dreamhead.moco.handler.ProxyResponseHandler;
import com.github.dreamhead.moco.handler.ResponseHandlers;
import com.github.dreamhead.moco.handler.SequenceContentHandler;
import com.github.dreamhead.moco.handler.StatusCodeResponseHandler;
import com.github.dreamhead.moco.handler.failover.DefaultFailoverExecutor;
import com.github.dreamhead.moco.handler.failover.Failover;
import com.github.dreamhead.moco.handler.failover.FailoverStrategy;
import com.github.dreamhead.moco.handler.proxy.ProxyConfig;
import com.github.dreamhead.moco.internal.ActualHttpServer;
import com.github.dreamhead.moco.matcher.AndRequestMatcher;
import com.github.dreamhead.moco.matcher.EqRequestMatcher;
import com.github.dreamhead.moco.matcher.JsonRequestMatcher;
import com.github.dreamhead.moco.matcher.MatchMatcher;
import com.github.dreamhead.moco.matcher.OrRequestMatcher;
import com.github.dreamhead.moco.matcher.XmlRequestMatcher;
import com.github.dreamhead.moco.monitor.DefaultLogFormatter;
import com.github.dreamhead.moco.monitor.FileLogWriter;
import com.github.dreamhead.moco.monitor.LogMonitor;
import com.github.dreamhead.moco.monitor.StdLogWriter;
import com.github.dreamhead.moco.procedure.LatencyProcedure;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.resource.ResourceFactory;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class Moco {
    public static HttpServer httpserver(int port, MocoConfig ... configs) {
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be greater than zero");
        return ActualHttpServer.createQuietServer((Optional<Integer>)Optional.of((Object)port), configs);
    }

    public static HttpServer httpserver(int port, MocoMonitor monitor, MocoConfig ... configs) {
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be greater than zero");
        return ActualHttpServer.createHttpServerWithMonitor((Optional<Integer>)Optional.of((Object)port), monitor, configs);
    }

    public static HttpServer httpserver(MocoConfig ... configs) {
        return ActualHttpServer.createQuietServer((Optional<Integer>)Optional.absent(), configs);
    }

    public static HttpServer httpserver(MocoMonitor monitor, MocoConfig ... configs) {
        return ActualHttpServer.createHttpServerWithMonitor((Optional<Integer>)Optional.absent(), (MocoMonitor)Preconditions.checkNotNull((Object)monitor, (Object)"Monitor should not be null"), configs);
    }

    public static MocoConfig context(String context) {
        return new MocoContextConfig((String)Preconditions.checkNotNull((Object)context, (Object)"Context should not be null"));
    }

    public static MocoConfig response(ResponseHandler handler) {
        return new MocoResponseConfig((ResponseHandler)Preconditions.checkNotNull((Object)handler, (Object)"Response should not be null"));
    }

    public static MocoConfig fileRoot(String fileRoot) {
        return new MocoFileRootConfig((String)Preconditions.checkNotNull((Object)fileRoot, (Object)"File root should not be null"));
    }

    public static MocoMonitor log() {
        return new LogMonitor(new DefaultLogFormatter(), new StdLogWriter());
    }

    public static MocoMonitor log(String filename) {
        return new LogMonitor(new DefaultLogFormatter(), new FileLogWriter(filename));
    }

    public static RequestMatcher by(String content) {
        return Moco.by(Moco.text((String)Preconditions.checkNotNull((Object)content, (Object)"Content should not be null")));
    }

    public static RequestMatcher by(Resource resource) {
        Preconditions.checkNotNull((Object)resource, (Object)"resource should not be null");
        return Moco.eq(Extractors.extractor(resource.id()), resource);
    }

    public static <T> RequestMatcher eq(RequestExtractor<T> extractor, String expected) {
        return Moco.eq((RequestExtractor)Preconditions.checkNotNull(extractor, (Object)"Extractor should not be null"), Moco.text((String)Preconditions.checkNotNull((Object)expected, (Object)"Expected content should not be null")));
    }

    public static <T> RequestMatcher eq(RequestExtractor<T> extractor, Resource expected) {
        return new EqRequestMatcher((RequestExtractor)Preconditions.checkNotNull(extractor, (Object)"Extractor should not be null"), (Resource)Preconditions.checkNotNull((Object)expected, (Object)"Expected content should not be null"));
    }

    public static RequestMatcher match(Resource resource) {
        Preconditions.checkNotNull((Object)resource, (Object)"Resource should not be null");
        return Moco.match(Extractors.extractor(resource.id()), resource);
    }

    public static <T> RequestMatcher match(RequestExtractor<T> extractor, String expected) {
        return Moco.match((RequestExtractor)Preconditions.checkNotNull(extractor, (Object)"Extractor should not be null"), Moco.text((String)Preconditions.checkNotNull((Object)expected, (Object)"Expected content should not be null")));
    }

    private static <T> RequestMatcher match(RequestExtractor<T> extractor, Resource expected) {
        return new MatchMatcher((RequestExtractor)Preconditions.checkNotNull(extractor, (Object)"Extractor should not be null"), (Resource)Preconditions.checkNotNull((Object)expected, (Object)"Expected resource should not be null"));
    }

    public static RequestMatcher and(RequestMatcher ... matchers) {
        return new AndRequestMatcher((Iterable<RequestMatcher>)ImmutableList.copyOf((Object[])matchers));
    }

    public static RequestMatcher or(RequestMatcher ... matchers) {
        return new OrRequestMatcher((Iterable<RequestMatcher>)ImmutableList.copyOf((Object[])matchers));
    }

    public static ContentResource text(String text) {
        return ResourceFactory.textResource((String)Preconditions.checkNotNull((Object)text, (Object)"Text should not be null"));
    }

    public static ResponseHandler with(String text) {
        return Moco.with(Moco.text((String)Preconditions.checkNotNull((Object)text, (Object)"Text should not be null")));
    }

    public static ResponseHandler with(Resource resource) {
        return ResponseHandlers.responseHandler((Resource)Preconditions.checkNotNull((Object)resource, (Object)"Resource should not be null"));
    }

    public static ResponseHandler with(MocoProcedure procedure) {
        return new ProcedureResponseHandler((MocoProcedure)Preconditions.checkNotNull((Object)procedure, (Object)"Procedure should not be null"));
    }

    public static Resource uri(String uri) {
        return ResourceFactory.uriResource((String)Preconditions.checkNotNull((Object)uri, (Object)"URI should not be null"));
    }

    public static Resource method(String httpMethod) {
        return ResourceFactory.methodResource((String)Preconditions.checkNotNull((Object)httpMethod, (Object)"HTTP method should not be null"));
    }

    public static RequestExtractor<String> header(String header) {
        return new HeaderRequestExtractor((String)Preconditions.checkNotNull((Object)header, (Object)"Header name should not be null"));
    }

    public static ResponseHandler header(String name, String value) {
        return Moco.header((String)Preconditions.checkNotNull((Object)name, (Object)"Header name should not be null"), Moco.text((String)Preconditions.checkNotNull((Object)value, (Object)"Header value should not be null")));
    }

    public static ResponseHandler header(String name, Resource value) {
        String key = (String)Preconditions.checkNotNull((Object)name, (Object)"Header name should not be null");
        if (key.trim().isEmpty()) {
            throw new IllegalArgumentException("Header name should not be empty");
        }
        return new HeaderResponseHandler(key, (Resource)Preconditions.checkNotNull((Object)value, (Object)"Header value should not be null"));
    }

    public static RequestExtractor<String> cookie(String key) {
        return new CookieRequestExtractor((String)Preconditions.checkNotNull((Object)key, (Object)"Cookie key should not be null"));
    }

    public static ResponseHandler cookie(String key, String value) {
        return Moco.cookie((String)Preconditions.checkNotNull((Object)key, (Object)"Cookie key should not be null"), Moco.text((String)Preconditions.checkNotNull((Object)value, (Object)"Cookie value should not be null")));
    }

    public static ResponseHandler cookie(String key, Resource resource) {
        return Moco.header("Set-Cookie", ResourceFactory.cookieResource((String)Preconditions.checkNotNull((Object)key, (Object)"Cookie key should not be null"), (Resource)Preconditions.checkNotNull((Object)resource, (Object)"Cookie value should not be null")));
    }

    public static RequestExtractor<String> form(String key) {
        return new FormRequestExtractor((String)Preconditions.checkNotNull((Object)key, (Object)"Form key should not be null"));
    }

    public static LatencyProcedure latency(long millis) {
        Preconditions.checkArgument((millis > 0L ? 1 : 0) != 0, (Object)"Latency must be greater than zero");
        return new LatencyProcedure(millis);
    }

    public static RequestExtractor<String> query(String param) {
        return new ParamRequestExtractor((String)Preconditions.checkNotNull((Object)param, (Object)"Query parameter should not be null"));
    }

    public static XPathRequestExtractor xpath(String xpath) {
        return new XPathRequestExtractor((String)Preconditions.checkNotNull((Object)xpath, (Object)"XPath should not be null"));
    }

    public static RequestMatcher xml(Resource resource) {
        Preconditions.checkNotNull((Object)resource, (Object)"Resource should not be null");
        return new XmlRequestMatcher(Extractors.extractor(resource.id()), resource);
    }

    public static RequestMatcher json(Resource resource) {
        Preconditions.checkNotNull((Object)resource, (Object)"JSON should not be null");
        return new JsonRequestMatcher(Extractors.extractor(resource.id()), resource);
    }

    public static JsonPathRequestExtractor jsonPath(String jsonPath) {
        return new JsonPathRequestExtractor((String)Preconditions.checkNotNull((Object)jsonPath, (Object)"JsonPath should not be null"));
    }

    public static ResponseHandler seq(String ... contents) {
        return Moco.seq((ResponseHandler[])FluentIterable.from((Iterable)ImmutableList.copyOf((Object[])contents)).transform(Moco.textToResource()).toArray(ResponseHandler.class));
    }

    public static ResponseHandler seq(Resource ... contents) {
        return Moco.seq((ResponseHandler[])FluentIterable.from((Iterable)ImmutableList.copyOf((Object[])contents)).transform(Moco.resourceToResourceHandler()).toArray(ResponseHandler.class));
    }

    public static ResponseHandler seq(ResponseHandler ... handlers) {
        return new SequenceContentHandler(handlers);
    }

    public static ContentResource file(String filename) {
        return ResourceFactory.fileResource(new File((String)Preconditions.checkNotNull((Object)filename, (Object)"Filename should not be null")));
    }

    public static ContentResource pathResource(String filename) {
        return ResourceFactory.classpathFileResource((String)Preconditions.checkNotNull((Object)filename, (Object)"Filename should not be null"));
    }

    public static Resource version(Resource resource) {
        return ResourceFactory.versionResource((Resource)Preconditions.checkNotNull((Object)resource, (Object)"Version should not be null"));
    }

    public static Resource version(String version) {
        return Moco.version(Moco.text((String)Preconditions.checkNotNull((Object)version, (Object)"Version should not be null")));
    }

    public static ResponseHandler status(int code) {
        Preconditions.checkArgument((code > 0 ? 1 : 0) != 0, (Object)"Status code must be greater than zero");
        return new StatusCodeResponseHandler(code);
    }

    public static ResponseHandler proxy(String url) {
        return Moco.proxy((String)Preconditions.checkNotNull((Object)url, (Object)"URL should not be null"), Failover.DEFAULT_FAILOVER);
    }

    public static ResponseHandler proxy(String url, Failover failover) {
        return new ProxyResponseHandler(Moco.toUrl((String)Preconditions.checkNotNull((Object)url, (Object)"URL should not be null")), (Failover)Preconditions.checkNotNull((Object)failover, (Object)"Failover should not be null"));
    }

    public static ResponseHandler proxy(ProxyConfig proxyConfig) {
        return Moco.proxy((ProxyConfig)Preconditions.checkNotNull((Object)proxyConfig), Failover.DEFAULT_FAILOVER);
    }

    public static ResponseHandler proxy(ProxyConfig proxyConfig, Failover failover) {
        return new ProxyBatchResponseHandler((ProxyConfig)Preconditions.checkNotNull((Object)proxyConfig), (Failover)Preconditions.checkNotNull((Object)failover));
    }

    public static ProxyConfig.Builder from(String localBase) {
        return ProxyConfig.builder(localBase);
    }

    public static Resource template(String template) {
        return Moco.template(Moco.text((String)Preconditions.checkNotNull((Object)template, (Object)"Template should not be null")));
    }

    public static Resource template(String template, String name, Object value) {
        return Moco.template(Moco.text((String)Preconditions.checkNotNull((Object)template, (Object)"Template should not be null")), (ImmutableMap<String, Object>)ImmutableMap.of((Object)Preconditions.checkNotNull((Object)name, (Object)"Template variable name should not be null"), (Object)Preconditions.checkNotNull((Object)value, (Object)"Template variable value should not be null")));
    }

    public static Resource template(String template, String name1, Object value1, String name2, Object value2) {
        return Moco.template(Moco.text((String)Preconditions.checkNotNull((Object)template, (Object)"Template should not be null")), (ImmutableMap<String, Object>)ImmutableMap.of((Object)Preconditions.checkNotNull((Object)name1, (Object)"Template variable name should not be null"), (Object)Preconditions.checkNotNull((Object)value1, (Object)"Template variable value should not be null"), (Object)Preconditions.checkNotNull((Object)name2, (Object)"Template variable name should not be null"), (Object)Preconditions.checkNotNull((Object)value2, (Object)"Template variable value should not be null")));
    }

    public static Resource template(String template, ImmutableMap<String, Object> variables) {
        return Moco.template(Moco.text((String)Preconditions.checkNotNull((Object)template, (Object)"Template should not be null")), (ImmutableMap<String, Object>)((ImmutableMap)Preconditions.checkNotNull(variables, (Object)"Template variable should not be null")));
    }

    public static Resource template(ContentResource template, ImmutableMap<String, Object> variables) {
        return ResourceFactory.templateResource((ContentResource)Preconditions.checkNotNull((Object)template, (Object)"Template should not be null"), (ImmutableMap<String, Object>)((ImmutableMap)Preconditions.checkNotNull(variables, (Object)"Template variable should not be null")));
    }

    public static Resource template(ContentResource resource) {
        return Moco.template((ContentResource)Preconditions.checkNotNull((Object)resource, (Object)"Template should not be null"), (ImmutableMap<String, Object>)ImmutableMap.of());
    }

    public static Resource template(ContentResource template, String name, Object value) {
        return Moco.template((ContentResource)Preconditions.checkNotNull((Object)template, (Object)"Template should not be null"), (ImmutableMap<String, Object>)ImmutableMap.of((Object)Preconditions.checkNotNull((Object)name, (Object)"Template variable name should not be null"), (Object)Preconditions.checkNotNull((Object)value, (Object)"Template variable value should not be null")));
    }

    public static Resource template(ContentResource template, String name1, Object value1, String name2, Object value2) {
        return Moco.template((ContentResource)Preconditions.checkNotNull((Object)template, (Object)"Template should not be null"), (ImmutableMap<String, Object>)ImmutableMap.of((Object)Preconditions.checkNotNull((Object)name1, (Object)"Template variable name should not be null"), (Object)Preconditions.checkNotNull((Object)value1, (Object)"Template variable value should not be null"), (Object)Preconditions.checkNotNull((Object)name2, (Object)"Template variable name should not be null"), (Object)Preconditions.checkNotNull((Object)value2, (Object)"Template variable value should not be null")));
    }

    public static Failover failover(String file) {
        return new Failover(Moco.failoverExecutor(file), FailoverStrategy.FAILOVER);
    }

    private static DefaultFailoverExecutor failoverExecutor(String file) {
        return new DefaultFailoverExecutor(new File((String)Preconditions.checkNotNull((Object)file, (Object)"Filename should not be null")));
    }

    public static Failover playback(String file) {
        return new Failover(Moco.failoverExecutor(file), FailoverStrategy.PLAYBACK);
    }

    public static MocoEventTrigger complete(MocoEventAction action) {
        return new MocoEventTrigger(MocoEvent.COMPLETE, (MocoEventAction)Preconditions.checkNotNull((Object)action, (Object)"Action should not be null"));
    }

    public static MocoEventAction async(MocoEventAction action) {
        return Moco.async((MocoEventAction)Preconditions.checkNotNull((Object)action, (Object)"Action should not be null"), Moco.latency(1000L));
    }

    public static MocoEventAction async(MocoEventAction action, LatencyProcedure procedure) {
        return new MocoAsyncAction((MocoEventAction)Preconditions.checkNotNull((Object)action, (Object)"Action should not be null"), (LatencyProcedure)Preconditions.checkNotNull((Object)procedure, (Object)"Procedure should not be null"));
    }

    public static MocoEventAction get(String url) {
        return new MocoRequestAction((String)Preconditions.checkNotNull((Object)url, (Object)"URL should not be null"), "GET", (Optional<ContentResource>)Optional.absent());
    }

    public static MocoEventAction post(String url, ContentResource content) {
        return new MocoRequestAction((String)Preconditions.checkNotNull((Object)url, (Object)"URL should not be null"), "POST", (Optional<ContentResource>)Optional.of((Object)Preconditions.checkNotNull((Object)content, (Object)"Content should not be null")));
    }

    public static MocoEventAction post(String url, String content) {
        return Moco.post(url, Moco.text((String)Preconditions.checkNotNull((Object)content, (Object)"Content should not be null")));
    }

    private static Function<String, ResponseHandler> textToResource() {
        return new Function<String, ResponseHandler>(){

            public ResponseHandler apply(String content) {
                return Moco.with(Moco.text(content));
            }
        };
    }

    private static Function<Resource, ResponseHandler> resourceToResourceHandler() {
        return new Function<Resource, ResponseHandler>(){

            public ResponseHandler apply(Resource content) {
                return Moco.with(content);
            }
        };
    }

    private static URL toUrl(String url) {
        try {
            return new URL((String)Preconditions.checkNotNull((Object)url, (Object)"URL should not be null"));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Moco() {
    }
}

