/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco;

import com.github.dreamhead.moco.mount.MountPredicate;
import com.github.dreamhead.moco.mount.MountTo;
import org.apache.commons.io.FilenameUtils;

public class MocoMount {
    public static MountTo to(String target) {
        return new MountTo(target);
    }

    public static MountPredicate include(final String wildcard) {
        return new MountPredicate(){

            public boolean apply(String filename) {
                return FilenameUtils.wildcardMatch((String)filename, (String)wildcard);
            }
        };
    }

    public static MountPredicate exclude(String wildcard) {
        return MocoMount.not(MocoMount.include(wildcard));
    }

    private static MountPredicate not(final MountPredicate predicate) {
        return new MountPredicate(){

            public boolean apply(String filename) {
                return !predicate.apply(filename);
            }
        };
    }
}

