/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco;

import com.github.dreamhead.moco.RequestHit;
import com.github.dreamhead.moco.UnexpectedRequestMatcher;
import com.github.dreamhead.moco.VerificationMode;
import com.github.dreamhead.moco.monitor.DefaultRequestHit;
import com.github.dreamhead.moco.verification.AtLeastVerification;
import com.github.dreamhead.moco.verification.AtMostVerification;
import com.github.dreamhead.moco.verification.TimesVerification;
import com.google.common.base.Preconditions;

public class MocoRequestHit {
    public static RequestHit requestHit() {
        return new DefaultRequestHit();
    }

    public static UnexpectedRequestMatcher unexpected() {
        return new UnexpectedRequestMatcher();
    }

    public static VerificationMode never() {
        return MocoRequestHit.times(0);
    }

    public static VerificationMode once() {
        return MocoRequestHit.times(1);
    }

    public static VerificationMode times(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"Times count must not be less than zero");
        return new TimesVerification(count);
    }

    public static VerificationMode atLeast(int count) {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Times count must be greater than zero");
        return new AtLeastVerification(count);
    }

    public static VerificationMode atMost(int count) {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Times count must be greater than zero");
        return new AtMostVerification(count);
    }

    private MocoRequestHit() {
    }
}

