/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco;

import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.MocoEventTrigger;
import com.github.dreamhead.moco.MocoProcedure;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.AndResponseHandler;
import com.github.dreamhead.moco.resource.Resource;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;

public abstract class ResponseSetting {
    protected ResponseHandler handler;
    protected List<MocoEventTrigger> eventTriggers = Lists.newArrayList();

    public ResponseSetting response(String content) {
        return this.response(Moco.text((String)Preconditions.checkNotNull((Object)content, (Object)"Content should not be null")));
    }

    public ResponseSetting response(Resource resource) {
        return this.response(Moco.with((Resource)Preconditions.checkNotNull((Object)resource, (Object)"Resource should not be null")));
    }

    public ResponseSetting response(ResponseHandler handler) {
        if (this.handler != null) {
            throw new RuntimeException("handler has already been set");
        }
        this.handler = (ResponseHandler)Preconditions.checkNotNull((Object)handler, (Object)"Handler should not be null");
        return this;
    }

    public ResponseSetting response(MocoProcedure procedure) {
        this.response(Moco.with((MocoProcedure)Preconditions.checkNotNull((Object)procedure, (Object)"Procedure should not be null")));
        return this;
    }

    public ResponseSetting response(ResponseHandler ... handlers) {
        this.response((ResponseHandler)new AndResponseHandler((Iterable<ResponseHandler>)ImmutableList.copyOf((Object[])handlers)));
        return this;
    }

    public ResponseSetting redirectTo(String url) {
        this.response(Moco.status(HttpResponseStatus.FOUND.code()), Moco.header("Location", (String)Preconditions.checkNotNull((Object)url, (Object)"URL should not be null")));
        return this;
    }

    public ResponseSetting on(MocoEventTrigger trigger) {
        this.eventTriggers.add((MocoEventTrigger)Preconditions.checkNotNull((Object)trigger, (Object)"Trigger should not be null"));
        return this;
    }

    protected static RequestMatcher context(String context) {
        return Moco.match(Moco.uri(context + ".*"));
    }
}

