/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.RequestMatcher;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;

public class VerificationData {
    private final ImmutableList<HttpRequest> requests;
    private final RequestMatcher matcher;
    private final String mismatchFormat;

    public VerificationData(ImmutableList<HttpRequest> requests, RequestMatcher matcher, String mismatchFormat) {
        this.requests = requests;
        this.matcher = matcher;
        this.mismatchFormat = mismatchFormat;
    }

    public String mismatchDescription(int actualSize, int expectedCount) {
        return String.format(this.mismatchFormat, expectedCount, actualSize);
    }

    public int matchedSize() {
        return FluentIterable.from(this.requests).filter(this.matched()).size();
    }

    private Predicate<HttpRequest> matched() {
        return new Predicate<HttpRequest>(){

            public boolean apply(HttpRequest request) {
                return VerificationData.this.matcher.match(request);
            }
        };
    }
}

