/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.action;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoEventAction;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.resource.Resource;
import com.google.common.base.Optional;
import io.netty.handler.codec.http.HttpMethod;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class MocoRequestAction
implements MocoEventAction {
    private final String url;
    private final String method;
    private final Optional<ContentResource> content;

    public MocoRequestAction(String url, String method, Optional<ContentResource> content) {
        this.url = url;
        this.method = method;
        this.content = content;
    }

    @Override
    public void execute() {
        CloseableHttpClient client = HttpClients.createDefault();
        try {
            HttpRequestBase request = this.createRequest(this.url, this.method);
            if (request instanceof HttpEntityEnclosingRequest && this.content.isPresent()) {
                ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new ByteArrayEntity(((ContentResource)this.content.get()).readFor(null)));
            }
            client.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpRequestBase createRequest(String url, String method) {
        if (HttpMethod.GET.name().equalsIgnoreCase(method)) {
            return new HttpGet(url);
        }
        if (HttpMethod.POST.name().equalsIgnoreCase(method)) {
            return new HttpPost(url);
        }
        throw new RuntimeException(String.format("unknown HTTP method: %s", method));
    }

    @Override
    public MocoEventAction apply(MocoConfig config) {
        if (this.content.isPresent()) {
            return this.applyContent(config, (ContentResource)this.content.get());
        }
        return this;
    }

    private MocoEventAction applyContent(MocoConfig config, ContentResource originalContent) {
        Resource content = originalContent.apply(config);
        if (content != originalContent) {
            return new MocoRequestAction(this.url, this.method, (Optional<ContentResource>)Optional.of((Object)((ContentResource)content)));
        }
        return this;
    }
}

