/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.dumper;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.dumper.HttpMessageBaseDumper;
import io.netty.util.internal.StringUtil;

public class HttpRequestDumper
extends HttpMessageBaseDumper<HttpRequest> {
    @Override
    public String dump(HttpRequest request) {
        StringBuilder buf = new StringBuilder();
        this.appendRequestProtocolLine(request, buf);
        buf.append(StringUtil.NEWLINE);
        this.headerJoiner.appendTo(buf, request.getHeaders());
        long contentLength = this.getContentLength(request, -1L);
        if (contentLength > 0L) {
            buf.append(StringUtil.NEWLINE);
            buf.append(StringUtil.NEWLINE);
            buf.append(request.getContent());
        }
        return buf.toString();
    }

    private void appendRequestProtocolLine(HttpRequest request, StringBuilder buf) {
        buf.append(request.getMethod());
        buf.append(' ');
        buf.append(request.getUri());
        buf.append(' ');
        buf.append(request.getVersion());
    }

    private long getContentLength(HttpRequest request, long defaultValue) {
        String contengLengthHeader = (String)request.getHeaders().get((Object)"Content-Length");
        if (contengLengthHeader != null) {
            try {
                return Long.parseLong(contengLengthHeader);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }
}

