/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.extractor;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.RequestExtractor;
import com.github.dreamhead.moco.extractor.HeaderRequestExtractor;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CookiesRequestExtractor
implements RequestExtractor<ImmutableMap<String, String>> {
    private final RequestExtractor<String> extractor = new HeaderRequestExtractor("Cookie");

    @Override
    public Optional<ImmutableMap<String, String>> extract(HttpRequest request) {
        Optional<String> cookieString = this.extractor.extract(request);
        if (!cookieString.isPresent()) {
            return Optional.absent();
        }
        return Optional.of(CookiesRequestExtractor.doExtract((String)cookieString.get()));
    }

    private static ImmutableMap<String, String> doExtract(String cookieString) {
        Set cookies = CookieDecoder.decode((String)cookieString);
        HashMap target = Maps.newHashMap();
        for (Cookie cookie : cookies) {
            target.put(cookie.getName(), cookie.getValue());
        }
        return ImmutableMap.copyOf((Map)target);
    }
}

