/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.extractor;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.RequestExtractor;
import com.github.dreamhead.moco.model.DefaultHttpRequest;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FormsRequestExtractor
implements RequestExtractor {
    public Optional<ImmutableMap<String, String>> extract(HttpRequest request) {
        HttpPostRequestDecoder decoder = null;
        try {
            decoder = new HttpPostRequestDecoder((io.netty.handler.codec.http.HttpRequest)((DefaultHttpRequest)request).toFullHttpRequest());
            Optional optional = Optional.of(this.doExtractForms(decoder));
            return optional;
        }
        catch (HttpPostRequestDecoder.IncompatibleDataDecoderException idde) {
            Optional optional = Optional.absent();
            return optional;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (decoder != null) {
                decoder.destroy();
            }
        }
    }

    private ImmutableMap<String, String> doExtractForms(HttpPostRequestDecoder decoder) throws IOException {
        List bodyHttpDatas = decoder.getBodyHttpDatas();
        HashMap forms = Maps.newHashMap();
        for (InterfaceHttpData data : bodyHttpDatas) {
            if (data.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
            Attribute attribute = (Attribute)data;
            forms.put(attribute.getName(), attribute.getValue());
        }
        return ImmutableMap.copyOf((Map)forms);
    }
}

