/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.extractor;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.RequestExtractor;
import com.github.dreamhead.moco.extractor.ContentRequestExtractor;
import com.github.dreamhead.moco.extractor.XmlExtractorHelper;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathRequestExtractor
implements RequestExtractor<String[]> {
    private final XmlExtractorHelper helper = new XmlExtractorHelper();
    private final ContentRequestExtractor extractor = new ContentRequestExtractor();
    private final XPathExpression xPathExpression;

    public XPathRequestExtractor(String xpath) {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath target = xPathfactory.newXPath();
        try {
            this.xPathExpression = target.compile(xpath);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Optional<String[]> extract(HttpRequest request) {
        try {
            NodeList list = (NodeList)this.xPathExpression.evaluate(this.helper.extractAsInputSource(request, this.extractor), XPathConstants.NODESET);
            ArrayList values = Lists.newArrayList();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                values.add(node.getNodeValue());
            }
            return Optional.of((Object)values.toArray(new String[values.size()]));
        }
        catch (XPathExpressionException e) {
            return Optional.of((Object)new String[0]);
        }
    }
}

