/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.handler.AbstractResponseHandler;
import com.github.dreamhead.moco.handler.HeaderDetector;
import com.github.dreamhead.moco.internal.SessionContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;

public abstract class AbstractContentResponseHandler
extends AbstractResponseHandler {
    private final HeaderDetector detector = new HeaderDetector();

    protected abstract void writeContentResponse(HttpRequest var1, ByteBuf var2);

    @Override
    public void writeToResponse(SessionContext context) {
        FullHttpResponse response = context.getResponse();
        ByteBuf buffer = Unpooled.buffer();
        this.writeContentResponse(context.getRequest(), buffer);
        response.content().writeBytes(buffer);
        HttpHeaders.addHeader((HttpMessage)response, (String)"Content-Length", (Object)buffer.writerIndex());
        if (!this.detector.hasContentType((HttpResponse)response)) {
            HttpHeaders.addHeader((HttpMessage)response, (String)"Content-Type", (Object)this.getContentType(context.getRequest()));
        }
    }

    protected String getContentType(HttpRequest request) {
        return "text/html; charset=UTF-8";
    }
}

