/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.handler.AbstractResponseHandler;
import com.github.dreamhead.moco.handler.failover.Failover;
import com.github.dreamhead.moco.handler.failover.FailoverStrategy;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.model.DefaultHttpRequest;
import com.github.dreamhead.moco.util.ByteBufs;
import com.google.common.base.Optional;
import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProxyResponseHandler
extends AbstractResponseHandler {
    private static Logger logger = LoggerFactory.getLogger(AbstractProxyResponseHandler.class);
    protected final Failover failover;

    protected abstract Optional<String> remoteUrl(String var1);

    public AbstractProxyResponseHandler(Failover failover) {
        this.failover = failover;
    }

    protected HttpRequestBase prepareRemoteRequest(FullHttpRequest request, URL url) {
        HttpRequestBase remoteRequest = this.createRemoteRequest(request, url);
        RequestConfig config = RequestConfig.custom().setRedirectsEnabled(false).build();
        remoteRequest.setConfig(config);
        remoteRequest.setProtocolVersion((ProtocolVersion)this.createVersion(request));
        long contentLength = HttpHeaders.getContentLength((HttpMessage)request, (long)-1L);
        if (contentLength > 0L && remoteRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)remoteRequest;
            entityRequest.setEntity(this.createEntity(request.content(), contentLength));
        }
        return remoteRequest;
    }

    private HttpRequestBase createRemoteRequest(FullHttpRequest request, URL url) {
        HttpRequestBase remoteRequest = this.createBaseRequest(url, request.getMethod());
        for (Map.Entry entry : request.headers()) {
            if (!this.isRemoteHeader(entry)) continue;
            remoteRequest.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        return remoteRequest;
    }

    private HttpEntity createEntity(ByteBuf content, long contentLength) {
        return new ByteArrayEntity(ByteBufs.asBytes(content), 0, (int)contentLength);
    }

    private org.apache.http.HttpVersion createVersion(FullHttpRequest request) {
        HttpVersion protocolVersion = request.getProtocolVersion();
        return new org.apache.http.HttpVersion(protocolVersion.majorVersion(), protocolVersion.minorVersion());
    }

    private boolean isRemoteHeader(Map.Entry<String, String> entry) {
        return !this.isHeader(entry, "Host") && !this.isHeader(entry, "Content-Length");
    }

    private boolean isHeader(Map.Entry<String, String> entry, String key) {
        return key.equalsIgnoreCase(entry.getKey());
    }

    private HttpRequestBase createBaseRequest(URL url, HttpMethod method) {
        if (method == HttpMethod.GET) {
            return new HttpGet(url.toString());
        }
        if (method == HttpMethod.POST) {
            return new HttpPost(url.toString());
        }
        if (method == HttpMethod.PUT) {
            return new HttpPut(url.toString());
        }
        if (method == HttpMethod.DELETE) {
            return new HttpDelete(url.toString());
        }
        if (method == HttpMethod.HEAD) {
            return new HttpHead(url.toString());
        }
        if (method == HttpMethod.OPTIONS) {
            return new HttpOptions(url.toString());
        }
        if (method == HttpMethod.TRACE) {
            return new HttpTrace(url.toString());
        }
        throw new RuntimeException("unknown HTTP method");
    }

    protected void setupResponse(HttpRequest request, FullHttpResponse response, HttpResponse remoteResponse) throws IOException {
        int statusCode = remoteResponse.getStatusLine().getStatusCode();
        if (statusCode == HttpResponseStatus.BAD_REQUEST.code()) {
            this.failover.failover(request, response);
            return;
        }
        this.setupNormalResponse(response, remoteResponse);
        this.failover.onCompleteResponse(request, response);
    }

    private void setupNormalResponse(FullHttpResponse response, HttpResponse remoteResponse) throws IOException {
        Header[] allHeaders;
        response.setProtocolVersion(HttpVersion.valueOf((String)remoteResponse.getProtocolVersion().toString()));
        response.setStatus(HttpResponseStatus.valueOf((int)remoteResponse.getStatusLine().getStatusCode()));
        for (Header header : allHeaders = remoteResponse.getAllHeaders()) {
            response.headers().set(header.getName(), (Object)header.getValue());
        }
        HttpEntity entity = remoteResponse.getEntity();
        if (entity != null && entity.getContentLength() > 0L) {
            ByteBuf buffer = Unpooled.copiedBuffer((byte[])ByteStreams.toByteArray((InputStream)entity.getContent()), (int)0, (int)((int)entity.getContentLength()));
            response.content().writeBytes(buffer);
        }
    }

    @Override
    public void writeToResponse(SessionContext context) {
        this.writeToResponse(context.getRequest(), context.getResponse());
    }

    private void writeToResponse(HttpRequest request, FullHttpResponse response) {
        Optional<URL> url = this.remoteUrl(((DefaultHttpRequest)request).toFullHttpRequest());
        if (!url.isPresent()) {
            return;
        }
        this.doProxy(request, response, (URL)url.get());
    }

    private void doProxy(HttpRequest request, FullHttpResponse response, URL remoteUrl) {
        if (this.failover.getStrategy() == FailoverStrategy.PLAYBACK) {
            try {
                this.failover.failover(request, response);
                return;
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        this.doForward(request, response, remoteUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doForward(HttpRequest request, FullHttpResponse response, URL remoteUrl) {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            FullHttpRequest httpRequest = ((DefaultHttpRequest)request).toFullHttpRequest();
            this.setupResponse(request, response, (HttpResponse)httpclient.execute((HttpUriRequest)this.prepareRemoteRequest(httpRequest, remoteUrl)));
        }
        catch (IOException e) {
            logger.error("Failed to load remote and try to failover", (Throwable)e);
            this.failover.failover(request, response);
        }
        finally {
            try {
                httpclient.close();
            }
            catch (IOException ignored) {}
        }
    }

    protected Optional<URL> remoteUrl(FullHttpRequest request) {
        QueryStringDecoder decoder = new QueryStringDecoder(request.getUri());
        Optional<String> remoteUrl = this.remoteUrl(decoder.path());
        if (!remoteUrl.isPresent()) {
            return Optional.absent();
        }
        QueryStringEncoder encoder = new QueryStringEncoder((String)remoteUrl.get());
        for (Map.Entry entry : decoder.parameters().entrySet()) {
            encoder.addParam((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
        try {
            return Optional.of((Object)new URL(encoder.toString()));
        }
        catch (MalformedURLException e) {
            return Optional.absent();
        }
    }
}

