/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.AbstractResponseHandler;
import com.github.dreamhead.moco.internal.SessionContext;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;

public class AndResponseHandler
extends AbstractResponseHandler {
    private final Iterable<ResponseHandler> handlers;

    public AndResponseHandler(Iterable<ResponseHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void writeToResponse(SessionContext context) {
        for (ResponseHandler handler : this.handlers) {
            handler.writeToResponse(context);
        }
    }

    @Override
    public ResponseHandler apply(MocoConfig config) {
        if (config.isFor("response")) {
            return super.apply(config);
        }
        return new AndResponseHandler((Iterable<ResponseHandler>)FluentIterable.from(this.handlers).transform(this.applyConfig(config)));
    }

    private Function<ResponseHandler, ResponseHandler> applyConfig(final MocoConfig config) {
        return new Function<ResponseHandler, ResponseHandler>(){

            public ResponseHandler apply(ResponseHandler handler) {
                return (ResponseHandler)handler.apply(config);
            }
        };
    }
}

