/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.AbstractContentResponseHandler;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.resource.Resource;
import io.netty.buffer.ByteBuf;

public class ContentHandler
extends AbstractContentResponseHandler {
    private final ContentResource resource;

    public ContentHandler(ContentResource resource) {
        this.resource = resource;
    }

    @Override
    protected void writeContentResponse(HttpRequest request, ByteBuf buffer) {
        buffer.writeBytes(this.resource.readFor(request));
    }

    @Override
    protected String getContentType(HttpRequest request) {
        return this.resource.getContentType();
    }

    @Override
    public ResponseHandler apply(MocoConfig config) {
        ResponseHandler handler = super.apply(config);
        if (handler != this) {
            return handler;
        }
        Resource resource = this.resource.apply(config);
        if (resource != this.resource) {
            return new ContentHandler((ContentResource)resource);
        }
        return this;
    }
}

