/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.AbstractResponseHandler;
import com.github.dreamhead.moco.handler.HeaderDetector;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.resource.Resource;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;

public class HeaderResponseHandler
extends AbstractResponseHandler {
    private final HeaderDetector detector = new HeaderDetector();
    private final String name;
    private final Resource resource;

    public HeaderResponseHandler(String name, Resource resource) {
        this.name = name;
        this.resource = resource;
    }

    @Override
    public void writeToResponse(SessionContext context) {
        FullHttpResponse response = context.getResponse();
        if (this.detector.hasHeader((HttpResponse)response, this.name)) {
            response.headers().remove(this.name);
        }
        HttpHeaders.addHeader((HttpMessage)response, (String)this.name, (Object)new String(this.resource.readFor(context.getRequest())));
    }

    @Override
    public ResponseHandler apply(MocoConfig config) {
        ResponseHandler handler = super.apply(config);
        if (handler != this) {
            return handler;
        }
        Resource resource = this.resource.apply(config);
        if (resource != this.resource) {
            return new HeaderResponseHandler(this.name, resource);
        }
        return this;
    }
}

