/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.AbstractResponseHandler;
import com.github.dreamhead.moco.internal.SessionContext;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;

public class SequenceContentHandler
extends AbstractResponseHandler {
    private final ResponseHandler[] handlers;
    private int index;

    public SequenceContentHandler(ResponseHandler[] handlers) {
        this.handlers = handlers;
    }

    @Override
    public void writeToResponse(SessionContext context) {
        this.handlers[this.current()].writeToResponse(context);
    }

    private int current() {
        int current = this.index++;
        if (this.index >= this.handlers.length) {
            this.index = this.handlers.length - 1;
        }
        return current;
    }

    @Override
    public ResponseHandler apply(MocoConfig config) {
        if (config.isFor("response")) {
            return super.apply(config);
        }
        FluentIterable transformedResources = FluentIterable.from((Iterable)ImmutableList.copyOf((Object[])this.handlers)).transform(this.applyConfig(config));
        return new SequenceContentHandler((ResponseHandler[])transformedResources.toArray(ResponseHandler.class));
    }

    private Function<ResponseHandler, ResponseHandler> applyConfig(final MocoConfig config) {
        return new Function<ResponseHandler, ResponseHandler>(){

            public ResponseHandler apply(ResponseHandler input) {
                return (ResponseHandler)input.apply(config);
            }
        };
    }
}

