/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler.failover;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.HttpResponse;
import com.github.dreamhead.moco.handler.failover.FailoverExecutor;
import com.github.dreamhead.moco.model.DefaultHttpResponse;
import com.github.dreamhead.moco.model.HttpRequestFailoverMatcher;
import com.github.dreamhead.moco.model.MessageFactory;
import com.github.dreamhead.moco.model.Session;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.netty.handler.codec.http.FullHttpResponse;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFailoverExecutor
implements FailoverExecutor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFailoverExecutor.class);
    private final TypeFactory factory = TypeFactory.defaultInstance();
    private final ObjectMapper mapper = new ObjectMapper();
    private final File file;

    public DefaultFailoverExecutor(File file) {
        this.file = file;
    }

    @Override
    public void onCompleteResponse(HttpRequest request, FullHttpResponse response) {
        try {
            ObjectWriter writer = this.mapper.writerWithDefaultPrettyPrinter();
            Session targetSession = Session.newSession(request, DefaultHttpResponse.newResponse(response));
            writer.writeValue(this.file, this.prepareTargetSessions(targetSession));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ImmutableList<Session> prepareTargetSessions(Session targetSession) {
        if (this.file.length() == 0L) {
            return ImmutableList.of((Object)targetSession);
        }
        return ImmutableList.builder().addAll(this.toUniqueSessions(targetSession, this.restoreSessions(this.file))).add((Object)targetSession).build();
    }

    private Iterable<Session> toUniqueSessions(Session targetSession, ImmutableList<Session> sessions) {
        Optional session = Iterables.tryFind(sessions, this.isForRequest(targetSession.getRequest()));
        if (session.isPresent()) {
            return FluentIterable.from(sessions).filter(Predicates.not(this.isForRequest(targetSession.getRequest())));
        }
        return sessions;
    }

    private ImmutableList<Session> restoreSessions(File file) {
        try {
            List sessions = (List)this.mapper.readValue(file, (JavaType)this.factory.constructCollectionType(List.class, Session.class));
            return ImmutableList.copyOf((Collection)sessions);
        }
        catch (JsonMappingException jme) {
            logger.error("exception found", (Throwable)jme);
            return ImmutableList.of();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void failover(HttpRequest request, FullHttpResponse response) {
        MessageFactory.writeResponse(response, this.failoverResponse(request));
    }

    private HttpResponse failoverResponse(HttpRequest request) {
        ImmutableList<Session> sessions = this.restoreSessions(this.file);
        Optional session = Iterables.tryFind(sessions, this.isForRequest(request));
        if (session.isPresent()) {
            return ((Session)session.get()).getResponse();
        }
        logger.error("No match request found: {}", (Object)request);
        throw new RuntimeException("no failover response found");
    }

    private Predicate<Session> isForRequest(final HttpRequest dumpedRequest) {
        return new Predicate<Session>(){

            public boolean apply(Session session) {
                HttpRequest request = session.getRequest();
                return new HttpRequestFailoverMatcher(request).match(dumpedRequest);
            }
        };
    }
}

