/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.HttpServer;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoEventTrigger;
import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.Setting;
import com.github.dreamhead.moco.monitor.QuietMonitor;
import com.github.dreamhead.moco.monitor.Slf4jMonitor;
import com.github.dreamhead.moco.setting.BaseSetting;
import com.github.dreamhead.moco.util.Configs;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public class ActualHttpServer
extends HttpServer {
    private Optional<Integer> port;
    private final MocoConfig[] configs;
    private final List<BaseSetting> settings = Lists.newArrayList();
    private RequestMatcher matcher = ActualHttpServer.anyRequest();
    private final MocoMonitor monitor;

    private ActualHttpServer(Optional<Integer> port, MocoMonitor monitor, MocoConfig ... configs) {
        this.port = port;
        this.monitor = monitor;
        this.configs = configs;
    }

    public ImmutableList<BaseSetting> getSettings() {
        return Configs.configItems(this.settings, this.configs);
    }

    public BaseSetting getAnySetting() {
        BaseSetting setting = new BaseSetting(Configs.configItem(this.matcher, this.configs));
        ResponseHandler configuredHandler = Configs.configItem(this.handler, this.configs);
        if (configuredHandler != null) {
            setting.response(configuredHandler);
        }
        for (MocoEventTrigger trigger : this.eventTriggers) {
            setting.on(trigger);
        }
        return setting;
    }

    public Optional<Integer> getPort() {
        return this.port;
    }

    public MocoMonitor getMonitor() {
        return this.monitor;
    }

    private void addSetting(BaseSetting setting) {
        this.settings.add(setting);
    }

    public HttpServer mergeHttpServer(ActualHttpServer thatServer) {
        ActualHttpServer newServer = ActualHttpServer.createLogServer(this.port, new MocoConfig[0]);
        newServer.addSettings(this.getSettings());
        newServer.addSettings(thatServer.getSettings());
        newServer.anySetting(Configs.configItem(this.matcher, this.configs), Configs.configItem(this.handler, this.configs));
        newServer.anySetting(Configs.configItem(thatServer.matcher, thatServer.configs), Configs.configItem(thatServer.handler, thatServer.configs));
        newServer.addEvents(this.eventTriggers);
        newServer.addEvents(thatServer.eventTriggers);
        return newServer;
    }

    private void addEvents(List<MocoEventTrigger> eventTriggers) {
        this.eventTriggers.addAll(eventTriggers);
    }

    private void anySetting(RequestMatcher matcher, ResponseHandler handler) {
        if (handler != null) {
            this.response(handler);
            this.matcher = matcher;
        }
    }

    private void addSettings(ImmutableList<BaseSetting> thatSettings) {
        for (BaseSetting thatSetting : thatSettings) {
            this.addSetting(thatSetting);
        }
    }

    @Override
    public int port() {
        if (this.port.isPresent()) {
            return (Integer)this.port.get();
        }
        throw new IllegalStateException("unbound port should not be returned");
    }

    @Override
    protected Setting onRequestAttached(RequestMatcher matcher) {
        BaseSetting baseSetting = new BaseSetting(matcher);
        this.addSetting(baseSetting);
        return baseSetting;
    }

    private static RequestMatcher anyRequest() {
        return new RequestMatcher(){

            @Override
            public boolean match(HttpRequest request) {
                return true;
            }

            @Override
            public RequestMatcher apply(MocoConfig config) {
                if (config.isFor("uri")) {
                    return ActualHttpServer.context(config.apply(""));
                }
                return this;
            }
        };
    }

    public static ActualHttpServer createHttpServerWithMonitor(Optional<Integer> port, MocoMonitor monitor, MocoConfig ... configs) {
        return new ActualHttpServer(port, monitor, configs);
    }

    public static ActualHttpServer createLogServer(Optional<Integer> port, MocoConfig ... configs) {
        return ActualHttpServer.createHttpServerWithMonitor(port, new Slf4jMonitor(), configs);
    }

    public static ActualHttpServer createQuietServer(Optional<Integer> port, MocoConfig ... configs) {
        return ActualHttpServer.createHttpServerWithMonitor(port, new QuietMonitor(), configs);
    }

    public void setPort(int port) {
        this.port = Optional.of((Object)port);
    }
}

