/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.internal.ActualHttpServer;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.model.DefaultHttpRequest;
import com.github.dreamhead.moco.setting.BaseSetting;
import com.google.common.collect.ImmutableList;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;

public class MocoHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final ImmutableList<BaseSetting> settings;
    private final BaseSetting anySetting;
    private final MocoMonitor monitor;

    public MocoHandler(ActualHttpServer server) {
        this.settings = server.getSettings();
        this.anySetting = server.getAnySetting();
        this.monitor = server.getMonitor();
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest message) throws Exception {
        this.closeIfNotKeepAlive(message, ctx.writeAndFlush((Object)this.handleRequest(message)));
    }

    private FullHttpResponse handleRequest(FullHttpRequest message) {
        HttpRequest request = DefaultHttpRequest.newRequest(message);
        FullHttpResponse response = this.getHttpResponse(request);
        this.prepareForKeepAlive(message, response);
        this.monitor.onMessageLeave(response);
        return response;
    }

    private FullHttpResponse getHttpResponse(HttpRequest request) {
        try {
            this.monitor.onMessageArrived(request);
            return this.doGetResponse(request);
        }
        catch (RuntimeException e) {
            this.monitor.onException(e);
            return this.defaultResponse(request, HttpResponseStatus.BAD_REQUEST);
        }
        catch (Exception e) {
            this.monitor.onException(e);
            return this.defaultResponse(request, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private FullHttpResponse doGetResponse(HttpRequest request) {
        FullHttpResponse response = this.defaultResponse(request, HttpResponseStatus.OK);
        SessionContext context = new SessionContext(request, response);
        for (BaseSetting setting : this.settings) {
            if (!setting.match(request)) continue;
            setting.writeToResponse(context);
            return response;
        }
        if (this.anySetting.match(request)) {
            this.anySetting.writeToResponse(context);
            return response;
        }
        this.monitor.onUnexpectedMessage(request);
        return this.defaultResponse(request, HttpResponseStatus.BAD_REQUEST);
    }

    private void closeIfNotKeepAlive(FullHttpRequest request, ChannelFuture future) {
        if (!HttpHeaders.isKeepAlive((HttpMessage)request)) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void prepareForKeepAlive(FullHttpRequest request, FullHttpResponse response) {
        if (HttpHeaders.isKeepAlive((HttpMessage)request)) {
            HttpHeaders.setKeepAlive((HttpMessage)response, (boolean)true);
            this.setContentLengthForKeepAlive(response);
        }
    }

    private void setContentLengthForKeepAlive(FullHttpResponse response) {
        if (!HttpHeaders.isContentLengthSet((HttpMessage)response)) {
            HttpHeaders.setContentLength((HttpMessage)response, (long)response.content().writerIndex());
        }
    }

    private FullHttpResponse defaultResponse(HttpRequest request, HttpResponseStatus status) {
        return new DefaultFullHttpResponse(HttpVersion.valueOf((String)request.getVersion()), status);
    }
}

