/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.Runner;
import com.github.dreamhead.moco.internal.ActualHttpServer;
import com.github.dreamhead.moco.internal.MocoHandler;
import com.github.dreamhead.moco.internal.MocoServer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;

public class MocoHttpServer
extends Runner {
    private final MocoServer server = new MocoServer();
    private final ActualHttpServer serverSetting;

    public MocoHttpServer(ActualHttpServer serverSetting) {
        this.serverSetting = serverSetting;
    }

    @Override
    public void start() {
        int port = this.server.start((Integer)this.serverSetting.getPort().or((Object)0), (ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(0x100000));
                pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
                pipeline.addLast("handler", (ChannelHandler)new MocoHandler(MocoHttpServer.this.serverSetting));
            }
        });
        this.serverSetting.setPort(port);
    }

    @Override
    public void stop() {
        this.server.stop();
    }
}

