/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.jayway.awaitility.Awaitility;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class MocoServer {
    private static final int DEFAULT_TIMEOUT = 3;
    private EventLoopGroup bossGroup = new NioEventLoopGroup();
    private EventLoopGroup workerGroup = new NioEventLoopGroup();
    private ChannelFuture future;
    private InetSocketAddress address;

    public int start(int port, ChannelHandler pipelineFactory) {
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler(pipelineFactory);
        try {
            this.future = bootstrap.bind(port).sync();
            SocketAddress socketAddress = this.future.channel().localAddress();
            this.address = (InetSocketAddress)socketAddress;
            return this.address.getPort();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        this.doStop();
        if (this.address != null) {
            Awaitility.await().atMost(3L, TimeUnit.SECONDS).until(this.serverIsClosed(this.address));
            this.address = null;
        }
    }

    private void doStop() {
        if (this.future != null) {
            this.future.channel().close().syncUninterruptibly();
            this.future = null;
        }
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
            this.bossGroup = null;
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.workerGroup = null;
        }
    }

    private Callable<Boolean> serverIsClosed(final InetSocketAddress address) {
        return new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    Socket socket = new Socket();
                    socket.connect(address);
                    return false;
                }
                catch (ConnectException e) {
                    return true;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

