/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.matcher;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.RequestExtractor;
import com.github.dreamhead.moco.RequestMatcher;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;

public abstract class AbstractOperatorMatcher<T>
implements RequestMatcher {
    protected final RequestExtractor<T> extractor;
    private final Predicate<String> predicate;

    protected AbstractOperatorMatcher(RequestExtractor<T> extractor, Predicate<String> predicate) {
        this.extractor = extractor;
        this.predicate = predicate;
    }

    @Override
    public boolean match(HttpRequest request) {
        Optional<T> extractContent = this.extractor.extract(request);
        if (!extractContent.isPresent()) {
            return false;
        }
        Object target = extractContent.get();
        if (target instanceof String) {
            return this.predicate.apply((Object)((String)target));
        }
        if (target instanceof String[]) {
            String[] contents;
            for (String content : contents = (String[])target) {
                if (!this.predicate.apply((Object)content)) continue;
                return true;
            }
        }
        return false;
    }
}

