/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.matcher;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.RequestMatcher;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;

public abstract class CompositeRequestMatcher
implements RequestMatcher {
    protected final Iterable<RequestMatcher> matchers;

    public CompositeRequestMatcher(Iterable<RequestMatcher> matchers) {
        this.matchers = matchers;
    }

    protected Iterable<RequestMatcher> applyToMatchers(MocoConfig config) {
        FluentIterable appliedMatchers = FluentIterable.from(this.matchers).transform(this.applyConfig(config));
        if (this.matchers.equals(appliedMatchers)) {
            return this.matchers;
        }
        return appliedMatchers;
    }

    private Function<RequestMatcher, RequestMatcher> applyConfig(final MocoConfig config) {
        return new Function<RequestMatcher, RequestMatcher>(){

            public RequestMatcher apply(RequestMatcher matcher) {
                return (RequestMatcher)matcher.apply(config);
            }
        };
    }
}

