/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.matcher;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.RequestExtractor;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.extractor.XmlExtractorHelper;
import com.github.dreamhead.moco.resource.Resource;
import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlRequestMatcher
implements RequestMatcher {
    private final XmlExtractorHelper helper = new XmlExtractorHelper();
    private final DocumentBuilder documentBuilder;
    private final RequestExtractor<String> extractor;
    private final Resource resource;

    public XmlRequestMatcher(RequestExtractor<String> extractor, Resource resource) {
        this.extractor = extractor;
        this.resource = resource;
        this.documentBuilder = this.documentBuilder();
    }

    @Override
    public boolean match(HttpRequest request) {
        try {
            Document requestDocument = this.extractDocument(request, this.extractor);
            Document resourceDocument = this.getResourceDocument(null, this.resource);
            return requestDocument.isEqualNode(resourceDocument);
        }
        catch (SAXException e) {
            return false;
        }
    }

    @Override
    public RequestMatcher apply(MocoConfig config) {
        if (config.isFor(this.resource.id())) {
            return new XmlRequestMatcher(this.extractor, this.resource.apply(config));
        }
        return this;
    }

    private Document getResourceDocument(HttpRequest request, Resource resource) throws SAXException {
        ByteArrayInputStream stream = new ByteArrayInputStream(resource.readFor(request));
        return this.extractDocument(new InputSource(stream), this);
    }

    private Document extractDocument(HttpRequest request, RequestExtractor<String> extractor) throws SAXException {
        return this.extractDocument(this.helper.extractAsInputSource(request, extractor), this);
    }

    public void trimChild(Node node, Node child) {
        if (child instanceof Text) {
            if (Strings.isNullOrEmpty((String)child.getNodeValue().trim())) {
                node.removeChild(child);
            }
            return;
        }
        if (child instanceof Element) {
            this.trimNode(child);
        }
    }

    private void trimNode(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = children.getLength() - 1; i >= 0; --i) {
            this.trimChild(node, children.item(i));
        }
    }

    public DocumentBuilder documentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setIgnoringComments(true);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public Document extractDocument(InputSource inputSource, XmlRequestMatcher xmlRequestMatcher) throws SAXException {
        try {
            Document document = xmlRequestMatcher.documentBuilder.parse(inputSource);
            document.normalizeDocument();
            this.trimNode(document);
            return document;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

