/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.extractor.CookiesRequestExtractor;
import com.github.dreamhead.moco.extractor.FormsRequestExtractor;
import com.github.dreamhead.moco.util.ByteBufs;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class DefaultHttpRequest
implements HttpRequest {
    private final Supplier<ImmutableMap<String, String>> formSupplier;
    private final Supplier<ImmutableMap<String, String>> cookieSupplier;
    private final String version;
    private final String content;
    private final ImmutableMap<String, String> headers;
    private final String method;
    private final String uri;
    private final ImmutableMap<String, String> queries;

    private DefaultHttpRequest(String version, String content, String method, String uri, ImmutableMap<String, String> headers, ImmutableMap<String, String> queries) {
        this.version = version;
        this.content = content;
        this.headers = headers;
        this.method = method;
        this.uri = uri;
        this.queries = queries;
        this.formSupplier = this.formSupplier();
        this.cookieSupplier = this.cookieSupplier();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public ImmutableMap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @JsonIgnore
    public ImmutableMap<String, String> getForms() {
        return (ImmutableMap)this.formSupplier.get();
    }

    @JsonIgnore
    public ImmutableMap<String, String> getCookies() {
        return (ImmutableMap)this.cookieSupplier.get();
    }

    @Override
    public ImmutableMap<String, String> getQueries() {
        return this.queries;
    }

    private Supplier<ImmutableMap<String, String>> formSupplier() {
        return Suppliers.memoize((Supplier)new Supplier<ImmutableMap<String, String>>(){

            public ImmutableMap<String, String> get() {
                Optional<ImmutableMap<String, String>> forms = new FormsRequestExtractor().extract(DefaultHttpRequest.this);
                return forms.isPresent() ? (ImmutableMap)forms.get() : ImmutableMap.of();
            }
        });
    }

    private Supplier<ImmutableMap<String, String>> cookieSupplier() {
        return Suppliers.memoize((Supplier)new Supplier<ImmutableMap<String, String>>(){

            public ImmutableMap<String, String> get() {
                Optional<ImmutableMap<String, String>> cookies = new CookiesRequestExtractor().extract(DefaultHttpRequest.this);
                return cookies.isPresent() ? (ImmutableMap)cookies.get() : ImmutableMap.of();
            }
        });
    }

    public String toString() {
        return Objects.toStringHelper((String)"HTTP Request").omitNullValues().add("uri", (Object)this.uri).add("version", (Object)this.version).add("method", (Object)this.method).add("queries", this.queries).add("headers", this.headers).add("content", (Object)this.content).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static String contentToString(FullHttpRequest request) {
        long contentLength = HttpHeaders.getContentLength((HttpMessage)request, (long)-1L);
        if (contentLength <= 0L) {
            return "";
        }
        return new String(ByteBufs.asBytes(request.content()), 0, (int)contentLength, Charset.defaultCharset());
    }

    public static HttpRequest newRequest(FullHttpRequest request) {
        QueryStringDecoder decoder = new QueryStringDecoder(request.getUri());
        HashMap queries = Maps.newHashMap();
        for (Map.Entry entry : decoder.parameters().entrySet()) {
            queries.put(entry.getKey(), ((List)entry.getValue()).get(0));
        }
        return DefaultHttpRequest.builder().withVersion(request.getProtocolVersion().text()).withHeaders((Map<String, String>)DefaultHttpRequest.collectHeaders((Iterable<Map.Entry<String, String>>)request.headers())).withMethod(request.getMethod().toString().toUpperCase()).withUri(decoder.path()).withQueries(queries).withContent(DefaultHttpRequest.contentToString(request)).build();
    }

    public FullHttpRequest toFullHttpRequest() {
        ByteBuf buffer = Unpooled.buffer();
        if (this.content != null) {
            buffer.writeBytes(this.content.getBytes());
        }
        QueryStringEncoder encoder = new QueryStringEncoder(this.uri);
        for (Map.Entry entry : this.queries.entrySet()) {
            encoder.addParam((String)entry.getKey(), (String)entry.getValue());
        }
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.valueOf((String)this.version), HttpMethod.valueOf((String)this.method), encoder.toString(), buffer);
        for (Map.Entry entry : this.headers.entrySet()) {
            request.headers().add((String)entry.getKey(), entry.getValue());
        }
        return request;
    }

    private static ImmutableMap<String, String> collectHeaders(Iterable<Map.Entry<String, String>> httpHeaders) {
        ImmutableMap.Builder headerBuilder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : httpHeaders) {
            headerBuilder.put(entry);
        }
        return headerBuilder.build();
    }

    public static final class Builder {
        private String version;
        private String content;
        private ImmutableMap<String, String> headers;
        private String method;
        private String uri;
        private ImmutableMap<String, String> queries;

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withContent(String content) {
            this.content = content;
            return this;
        }

        public Builder withHeaders(Map<String, String> headers) {
            if (headers != null) {
                this.headers = ImmutableMap.copyOf(headers);
            }
            return this;
        }

        public Builder withMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder withUri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder withQueries(Map<String, String> queries) {
            if (queries != null) {
                this.queries = ImmutableMap.copyOf(queries);
            }
            return this;
        }

        public DefaultHttpRequest build() {
            return new DefaultHttpRequest(this.version, this.content, this.method, this.uri, this.headers, this.queries);
        }
    }
}

