/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.dreamhead.moco.HttpResponse;
import com.google.common.collect.ImmutableMap;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.nio.charset.Charset;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public class DefaultHttpResponse
implements HttpResponse {
    private final String version;
    private final String content;
    private final ImmutableMap<String, String> headers;
    private final int status;

    public DefaultHttpResponse(String version, int status, ImmutableMap<String, String> headers, String content) {
        this.version = version;
        this.headers = headers;
        this.content = content;
        this.status = status;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public ImmutableMap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public static DefaultHttpResponse newResponse(FullHttpResponse response) {
        ImmutableMap.Builder headerBuilder = ImmutableMap.builder();
        for (Map.Entry entry : response.headers()) {
            headerBuilder.put(entry);
        }
        return DefaultHttpResponse.builder().withVersion(response.getProtocolVersion().text()).withStatus(response.getStatus().code()).withHeaders((Map<String, String>)headerBuilder.build()).withContent(response.content().toString(Charset.defaultCharset())).build();
    }

    public FullHttpResponse toFullHttpResponse() {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.valueOf((String)this.version), HttpResponseStatus.valueOf((int)this.status));
        for (Map.Entry entry : this.headers.entrySet()) {
            response.headers().add((String)entry.getKey(), entry.getValue());
        }
        response.content().writeBytes(this.content.getBytes());
        return response;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String version;
        private String content;
        private ImmutableMap<String, String> headers;
        private int status;

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withContent(String content) {
            this.content = content;
            return this;
        }

        public Builder withHeaders(Map<String, String> headers) {
            if (headers != null) {
                this.headers = ImmutableMap.copyOf(headers);
            }
            return this;
        }

        public Builder withStatus(int code) {
            this.status = code;
            return this;
        }

        public DefaultHttpResponse build() {
            return new DefaultHttpResponse(this.version, this.status, this.headers, this.content);
        }
    }
}

