/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.model;

import com.github.dreamhead.moco.HttpRequest;
import com.google.common.base.Strings;
import java.util.Map;

public class HttpRequestFailoverMatcher {
    private final HttpRequest failover;

    public HttpRequestFailoverMatcher(HttpRequest failover) {
        this.failover = failover;
    }

    public boolean match(HttpRequest target) {
        return this.doMatch(this.failover.getUri(), target.getUri()) && this.doMatch(this.failover.getVersion(), target.getVersion()) && this.doMatch(this.failover.getContent(), target.getContent()) && this.doMatch((Map<String, String>)this.failover.getHeaders(), (Map<String, String>)target.getHeaders()) && this.doMatch(this.failover.getMethod(), target.getMethod()) && this.doMatch((Map<String, String>)this.failover.getQueries(), (Map<String, String>)target.getQueries());
    }

    protected boolean doMatch(Map<String, String> thisField, Map<String, String> thatField) {
        if (thisField == null || thisField.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, String> entry : thisField.entrySet()) {
            if (this.doMatch(entry.getValue(), thatField.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    protected boolean doMatch(String thisField, String thatField) {
        return Strings.isNullOrEmpty((String)thisField) || thisField.equals(thatField);
    }
}

