/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.monitor;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.RequestHit;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.UnexpectedRequestMatcher;
import com.github.dreamhead.moco.VerificationData;
import com.github.dreamhead.moco.VerificationMode;
import com.github.dreamhead.moco.monitor.AbstractMonitor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public class DefaultRequestHit
extends AbstractMonitor
implements RequestHit {
    private List<HttpRequest> unexpectedRequests = Lists.newArrayList();
    private List<HttpRequest> requests = Lists.newArrayList();

    @Override
    public void onMessageArrived(HttpRequest request) {
        this.requests.add(request);
    }

    @Override
    public void onUnexpectedMessage(HttpRequest request) {
        this.unexpectedRequests.add(request);
    }

    @Override
    public void verify(UnexpectedRequestMatcher matcher, VerificationMode mode) {
        mode.verify(new VerificationData((ImmutableList<HttpRequest>)ImmutableList.copyOf(this.unexpectedRequests), matcher, "expect unexpected request hit %d times but %d times"));
    }

    @Override
    public void verify(RequestMatcher matcher, VerificationMode mode) {
        mode.verify(new VerificationData((ImmutableList<HttpRequest>)ImmutableList.copyOf(this.requests), matcher, "expect request hit %d times but %d times"));
    }
}

