/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.monitor;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.monitor.LogFormatter;
import com.github.dreamhead.moco.monitor.LogWriter;
import io.netty.handler.codec.http.FullHttpResponse;

public class LogMonitor
implements MocoMonitor {
    private LogWriter writer;
    private LogFormatter formatter;

    public LogMonitor(LogFormatter formatter, LogWriter writer) {
        this.writer = writer;
        this.formatter = formatter;
    }

    @Override
    public void onMessageArrived(HttpRequest request) {
        this.writer.write(this.formatter.format(request));
    }

    @Override
    public void onException(Exception e) {
        this.writer.write(this.formatter.format(e));
    }

    @Override
    public void onMessageLeave(FullHttpResponse response) {
        this.writer.write(this.formatter.format(response));
    }

    @Override
    public void onUnexpectedMessage(HttpRequest request) {
    }
}

