/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.mount;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.AbstractContentResponseHandler;
import com.github.dreamhead.moco.mount.MountPathExtractor;
import com.github.dreamhead.moco.mount.MountTo;
import com.github.dreamhead.moco.util.FileContentType;
import com.google.common.base.Optional;
import com.google.common.io.Files;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;

public class MountHandler
extends AbstractContentResponseHandler {
    private final MountPathExtractor extractor;
    private final File dir;
    private final MountTo target;

    public MountHandler(File dir, MountTo target) {
        this.dir = dir;
        this.target = target;
        this.extractor = new MountPathExtractor(target);
    }

    @Override
    protected void writeContentResponse(HttpRequest request, ByteBuf buffer) {
        try {
            buffer.writeBytes(Files.toByteArray((File)this.targetFile(request)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File targetFile(HttpRequest request) {
        Optional<String> relativePath = this.extractor.extract(request);
        return new File(this.dir, (String)relativePath.get());
    }

    @Override
    protected String getContentType(HttpRequest request) {
        return new FileContentType(this.targetFile(request).getName()).getContentType();
    }

    @Override
    public ResponseHandler apply(MocoConfig config) {
        if (config.isFor("response")) {
            return super.apply(config);
        }
        if (config.isFor("uri")) {
            return new MountHandler(this.dir, this.target.apply(config));
        }
        if (config.isFor("file")) {
            return new MountHandler(new File(config.apply(this.dir.getName())), this.target);
        }
        return this;
    }
}

