/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.resource;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.resource.ResourceConfigApplier;
import com.github.dreamhead.moco.resource.ResourceFactory;
import com.google.common.collect.ImmutableMap;
import java.io.File;

public class ResourceConfigApplierFactory {
    public static ResourceConfigApplier DO_NOTHING_APPLIER = new ResourceConfigApplier(){

        @Override
        public Resource apply(MocoConfig config, Resource resource) {
            return resource;
        }
    };

    public static ResourceConfigApplier fileConfigApplier(String id, final File file) {
        return new SelfResourceConfigApplier(id){

            @Override
            protected Resource newResource(MocoConfig config) {
                return ResourceFactory.fileResource(new File(config.apply(file.getName())));
            }
        };
    }

    public static ResourceConfigApplier cookieConfigApplier(final String key, final Resource cookieResource) {
        return new EmbeddedResourceConfigApplier(cookieResource){

            @Override
            protected Resource newResource(MocoConfig config) {
                return ResourceFactory.cookieResource(key, cookieResource.apply(config));
            }
        };
    }

    public static ResourceConfigApplier templateConfigApplier(final ContentResource template, final ImmutableMap<String, Object> variables) {
        return new EmbeddedResourceConfigApplier(template){

            @Override
            protected Resource newResource(MocoConfig config) {
                return ResourceFactory.templateResource((ContentResource)template.apply(config), (ImmutableMap<String, Object>)variables);
            }
        };
    }

    public static ResourceConfigApplier uriConfigApplier(String id, final String uri) {
        return new SelfResourceConfigApplier(id){

            @Override
            protected Resource newResource(MocoConfig config) {
                return ResourceFactory.uriResource(config.apply(uri));
            }
        };
    }

    private ResourceConfigApplierFactory() {
    }

    private static abstract class EmbeddedResourceConfigApplier
    extends BaseResourceConfigAppllier {
        private Resource resource;

        private EmbeddedResourceConfigApplier(Resource resource) {
            this.resource = resource;
        }

        @Override
        protected String id() {
            return this.resource.id();
        }
    }

    private static abstract class SelfResourceConfigApplier
    extends BaseResourceConfigAppllier {
        private String id;

        private SelfResourceConfigApplier(String id) {
            this.id = id;
        }

        @Override
        protected String id() {
            return this.id;
        }
    }

    private static abstract class BaseResourceConfigAppllier
    implements ResourceConfigApplier {
        private BaseResourceConfigAppllier() {
        }

        protected abstract Resource newResource(MocoConfig var1);

        protected abstract String id();

        @Override
        public Resource apply(MocoConfig config, Resource resource) {
            if (config.isFor(this.id())) {
                return this.newResource(config);
            }
            return resource;
        }
    }
}

