/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.resource;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.resource.IdFactory;
import com.github.dreamhead.moco.resource.Identifiable;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.resource.ResourceConfigApplier;
import com.github.dreamhead.moco.resource.ResourceConfigApplierFactory;
import com.github.dreamhead.moco.resource.ResourceReader;
import com.github.dreamhead.moco.resource.reader.ClasspathFileResourceReader;
import com.github.dreamhead.moco.resource.reader.ContentResourceReader;
import com.github.dreamhead.moco.resource.reader.FileResourceReader;
import com.github.dreamhead.moco.resource.reader.TemplateResourceReader;
import com.github.dreamhead.moco.util.Cookies;
import com.google.common.collect.ImmutableMap;
import java.io.File;

public class ResourceFactory {
    public static ContentResource textResource(final String text) {
        return ResourceFactory.contentResource(IdFactory.id("text"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, new ContentResourceReader(){

            @Override
            public String getContentType() {
                return "text/plain; charset=UTF-8";
            }

            @Override
            public byte[] readFor(HttpRequest request) {
                return text.getBytes();
            }
        });
    }

    public static ContentResource fileResource(File file) {
        String fileId = "file";
        return ResourceFactory.contentResource(IdFactory.id(fileId), ResourceConfigApplierFactory.fileConfigApplier(fileId, file), new FileResourceReader(file));
    }

    public static ContentResource classpathFileResource(String filename) {
        return ResourceFactory.contentResource(IdFactory.id("pathresource"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, new ClasspathFileResourceReader(filename));
    }

    public static Resource methodResource(final String method) {
        return ResourceFactory.resource(IdFactory.id("method"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, new ResourceReader(){

            @Override
            public byte[] readFor(HttpRequest request) {
                return method.toUpperCase().getBytes();
            }
        });
    }

    public static Resource versionResource(final Resource version) {
        return ResourceFactory.resource(IdFactory.id("version"), ResourceConfigApplierFactory.DO_NOTHING_APPLIER, new ResourceReader(){

            @Override
            public byte[] readFor(HttpRequest request) {
                return version.readFor(request);
            }
        });
    }

    public static Resource cookieResource(final String key, final Resource resource) {
        return ResourceFactory.resource(IdFactory.id("cookie"), ResourceConfigApplierFactory.cookieConfigApplier(key, resource), new ResourceReader(){

            @Override
            public byte[] readFor(HttpRequest request) {
                return new Cookies().encodeCookie(key, new String(resource.readFor(request))).getBytes();
            }
        });
    }

    public static ContentResource templateResource(ContentResource template, ImmutableMap<String, Object> variables) {
        return ResourceFactory.contentResource(IdFactory.id("template"), ResourceConfigApplierFactory.templateConfigApplier(template, variables), new TemplateResourceReader(template, variables));
    }

    public static Resource uriResource(final String uri) {
        return ResourceFactory.resource(IdFactory.id("uri"), ResourceConfigApplierFactory.uriConfigApplier("uri", uri), new ResourceReader(){

            @Override
            public byte[] readFor(HttpRequest request) {
                return uri.getBytes();
            }
        });
    }

    private static ContentResource contentResource(Identifiable id, ResourceConfigApplier applier, ContentResourceReader reader) {
        return new ContentResource(id, applier, reader);
    }

    private static Resource resource(Identifiable id, ResourceConfigApplier applier, ResourceReader reader) {
        return new Resource(id, applier, reader);
    }

    private ResourceFactory() {
    }
}

